/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeployedApplicationUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="applicationKey")
    private final String applicationKey;
    @JsonProperty(value="fleetId")
    private final String fleetId;
    @JsonProperty(value="applicationName")
    private final String applicationName;
    @JsonProperty(value="applicationType")
    private final String applicationType;
    @JsonProperty(value="isClustered")
    private final Boolean isClustered;
    @JsonProperty(value="approximateJavaServerInstanceCount")
    private final Integer approximateJavaServerInstanceCount;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="timeFirstSeen")
    private final Date timeFirstSeen;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;

    @Deprecated
    @ConstructorProperties(value={"applicationKey", "fleetId", "applicationName", "applicationType", "isClustered", "approximateJavaServerInstanceCount", "timeStart", "timeEnd", "timeFirstSeen", "timeLastSeen"})
    public DeployedApplicationUsage(String applicationKey, String fleetId, String applicationName, String applicationType, Boolean isClustered, Integer approximateJavaServerInstanceCount, Date timeStart, Date timeEnd, Date timeFirstSeen, Date timeLastSeen) {
        this.applicationKey = applicationKey;
        this.fleetId = fleetId;
        this.applicationName = applicationName;
        this.applicationType = applicationType;
        this.isClustered = isClustered;
        this.approximateJavaServerInstanceCount = approximateJavaServerInstanceCount;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeFirstSeen = timeFirstSeen;
        this.timeLastSeen = timeLastSeen;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public Boolean getIsClustered() {
        return this.isClustered;
    }

    public Integer getApproximateJavaServerInstanceCount() {
        return this.approximateJavaServerInstanceCount;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Date getTimeFirstSeen() {
        return this.timeFirstSeen;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeployedApplicationUsage(");
        sb.append("super=").append(super.toString());
        sb.append("applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(", fleetId=").append(String.valueOf(this.fleetId));
        sb.append(", applicationName=").append(String.valueOf(this.applicationName));
        sb.append(", applicationType=").append(String.valueOf(this.applicationType));
        sb.append(", isClustered=").append(String.valueOf(this.isClustered));
        sb.append(", approximateJavaServerInstanceCount=").append(String.valueOf(this.approximateJavaServerInstanceCount));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", timeFirstSeen=").append(String.valueOf(this.timeFirstSeen));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeployedApplicationUsage)) {
            return false;
        }
        DeployedApplicationUsage other = (DeployedApplicationUsage)((Object)o);
        return Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.applicationName, other.applicationName) && Objects.equals(this.applicationType, other.applicationType) && Objects.equals(this.isClustered, other.isClustered) && Objects.equals(this.approximateJavaServerInstanceCount, other.approximateJavaServerInstanceCount) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.timeFirstSeen, other.timeFirstSeen) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.applicationName == null ? 43 : this.applicationName.hashCode());
        result = result * 59 + (this.applicationType == null ? 43 : this.applicationType.hashCode());
        result = result * 59 + (this.isClustered == null ? 43 : this.isClustered.hashCode());
        result = result * 59 + (this.approximateJavaServerInstanceCount == null ? 43 : this.approximateJavaServerInstanceCount.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.timeFirstSeen == null ? 43 : this.timeFirstSeen.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="applicationKey")
        private String applicationKey;
        @JsonProperty(value="fleetId")
        private String fleetId;
        @JsonProperty(value="applicationName")
        private String applicationName;
        @JsonProperty(value="applicationType")
        private String applicationType;
        @JsonProperty(value="isClustered")
        private Boolean isClustered;
        @JsonProperty(value="approximateJavaServerInstanceCount")
        private Integer approximateJavaServerInstanceCount;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="timeFirstSeen")
        private Date timeFirstSeen;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            this.__explicitlySet__.add("applicationKey");
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            this.__explicitlySet__.add("fleetId");
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            this.__explicitlySet__.add("applicationName");
            return this;
        }

        public Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            this.__explicitlySet__.add("applicationType");
            return this;
        }

        public Builder isClustered(Boolean isClustered) {
            this.isClustered = isClustered;
            this.__explicitlySet__.add("isClustered");
            return this;
        }

        public Builder approximateJavaServerInstanceCount(Integer approximateJavaServerInstanceCount) {
            this.approximateJavaServerInstanceCount = approximateJavaServerInstanceCount;
            this.__explicitlySet__.add("approximateJavaServerInstanceCount");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder timeFirstSeen(Date timeFirstSeen) {
            this.timeFirstSeen = timeFirstSeen;
            this.__explicitlySet__.add("timeFirstSeen");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public DeployedApplicationUsage build() {
            DeployedApplicationUsage model = new DeployedApplicationUsage(this.applicationKey, this.fleetId, this.applicationName, this.applicationType, this.isClustered, this.approximateJavaServerInstanceCount, this.timeStart, this.timeEnd, this.timeFirstSeen, this.timeLastSeen);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeployedApplicationUsage model) {
            if (model.wasPropertyExplicitlySet("applicationKey")) {
                this.applicationKey(model.getApplicationKey());
            }
            if (model.wasPropertyExplicitlySet("fleetId")) {
                this.fleetId(model.getFleetId());
            }
            if (model.wasPropertyExplicitlySet("applicationName")) {
                this.applicationName(model.getApplicationName());
            }
            if (model.wasPropertyExplicitlySet("applicationType")) {
                this.applicationType(model.getApplicationType());
            }
            if (model.wasPropertyExplicitlySet("isClustered")) {
                this.isClustered(model.getIsClustered());
            }
            if (model.wasPropertyExplicitlySet("approximateJavaServerInstanceCount")) {
                this.approximateJavaServerInstanceCount(model.getApproximateJavaServerInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("timeFirstSeen")) {
                this.timeFirstSeen(model.getTimeFirstSeen());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            return this;
        }
    }
}

