/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class X509FederationRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="certificate")
    private final String certificate;
    @JsonProperty(value="publicKey")
    private final String publicKey;
    @JsonProperty(value="intermediateCertificates")
    private final List<String> intermediateCertificates;

    @Deprecated
    @ConstructorProperties(value={"certificate", "publicKey", "intermediateCertificates"})
    public X509FederationRequest(String certificate, String publicKey, List<String> intermediateCertificates) {
        this.certificate = certificate;
        this.publicKey = publicKey;
        this.intermediateCertificates = intermediateCertificates;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public List<String> getIntermediateCertificates() {
        return this.intermediateCertificates;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("X509FederationRequest(");
        sb.append("super=").append(super.toString());
        sb.append("certificate=").append(String.valueOf(this.certificate));
        sb.append(", publicKey=").append(String.valueOf(this.publicKey));
        sb.append(", intermediateCertificates=").append(String.valueOf(this.intermediateCertificates));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X509FederationRequest)) {
            return false;
        }
        X509FederationRequest other = (X509FederationRequest)((Object)o);
        return Objects.equals(this.certificate, other.certificate) && Objects.equals(this.publicKey, other.publicKey) && Objects.equals(this.intermediateCertificates, other.intermediateCertificates) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.certificate == null ? 43 : this.certificate.hashCode());
        result = result * 59 + (this.publicKey == null ? 43 : this.publicKey.hashCode());
        result = result * 59 + (this.intermediateCertificates == null ? 43 : this.intermediateCertificates.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="certificate")
        private String certificate;
        @JsonProperty(value="publicKey")
        private String publicKey;
        @JsonProperty(value="intermediateCertificates")
        private List<String> intermediateCertificates;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder certificate(String certificate) {
            this.certificate = certificate;
            this.__explicitlySet__.add("certificate");
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            this.__explicitlySet__.add("publicKey");
            return this;
        }

        public Builder intermediateCertificates(List<String> intermediateCertificates) {
            this.intermediateCertificates = intermediateCertificates;
            this.__explicitlySet__.add("intermediateCertificates");
            return this;
        }

        public X509FederationRequest build() {
            X509FederationRequest model = new X509FederationRequest(this.certificate, this.publicKey, this.intermediateCertificates);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(X509FederationRequest model) {
            if (model.wasPropertyExplicitlySet("certificate")) {
                this.certificate(model.getCertificate());
            }
            if (model.wasPropertyExplicitlySet("publicKey")) {
                this.publicKey(model.getPublicKey());
            }
            if (model.wasPropertyExplicitlySet("intermediateCertificates")) {
                this.intermediateCertificates(model.getIntermediateCertificates());
            }
            return this;
        }
    }
}

