/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class User
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="isOTP")
    private final Boolean isOTP;
    @JsonProperty(value="isMfaActivated")
    private final Boolean isMfaActivated;
    @JsonProperty(value="isMfaVerified")
    private final Boolean isMfaVerified;

    @Deprecated
    @ConstructorProperties(value={"id", "name", "isOTP", "isMfaActivated", "isMfaVerified"})
    public User(String id, String name, Boolean isOTP, Boolean isMfaActivated, Boolean isMfaVerified) {
        this.id = id;
        this.name = name;
        this.isOTP = isOTP;
        this.isMfaActivated = isMfaActivated;
        this.isMfaVerified = isMfaVerified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsOTP() {
        return this.isOTP;
    }

    public Boolean getIsMfaActivated() {
        return this.isMfaActivated;
    }

    public Boolean getIsMfaVerified() {
        return this.isMfaVerified;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("User(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", isOTP=").append(String.valueOf(this.isOTP));
        sb.append(", isMfaActivated=").append(String.valueOf(this.isMfaActivated));
        sb.append(", isMfaVerified=").append(String.valueOf(this.isMfaVerified));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.isOTP, other.isOTP) && Objects.equals(this.isMfaActivated, other.isMfaActivated) && Objects.equals(this.isMfaVerified, other.isMfaVerified) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.isOTP == null ? 43 : this.isOTP.hashCode());
        result = result * 59 + (this.isMfaActivated == null ? 43 : this.isMfaActivated.hashCode());
        result = result * 59 + (this.isMfaVerified == null ? 43 : this.isMfaVerified.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="isOTP")
        private Boolean isOTP;
        @JsonProperty(value="isMfaActivated")
        private Boolean isMfaActivated;
        @JsonProperty(value="isMfaVerified")
        private Boolean isMfaVerified;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder isOTP(Boolean isOTP) {
            this.isOTP = isOTP;
            this.__explicitlySet__.add("isOTP");
            return this;
        }

        public Builder isMfaActivated(Boolean isMfaActivated) {
            this.isMfaActivated = isMfaActivated;
            this.__explicitlySet__.add("isMfaActivated");
            return this;
        }

        public Builder isMfaVerified(Boolean isMfaVerified) {
            this.isMfaVerified = isMfaVerified;
            this.__explicitlySet__.add("isMfaVerified");
            return this;
        }

        public User build() {
            User model = new User(this.id, this.name, this.isOTP, this.isMfaActivated, this.isMfaVerified);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(User model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("isOTP")) {
                this.isOTP(model.getIsOTP());
            }
            if (model.wasPropertyExplicitlySet("isMfaActivated")) {
                this.isMfaActivated(model.getIsMfaActivated());
            }
            if (model.wasPropertyExplicitlySet("isMfaVerified")) {
                this.isMfaVerified(model.getIsMfaVerified());
            }
            return this;
        }
    }
}

