/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.identitydataplane.model.ThinAuthorizationResponse;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ThinAssociationAuthorizationResponse
extends ExplicitlySetBmcModel {
    @JsonProperty(value="responses")
    private final List<ThinAuthorizationResponse> responses;
    @JsonProperty(value="associationResult")
    private final AssociationResult associationResult;
    @JsonProperty(value="decisionCacheDuration")
    private final String decisionCacheDuration;

    @Deprecated
    @ConstructorProperties(value={"responses", "associationResult", "decisionCacheDuration"})
    public ThinAssociationAuthorizationResponse(List<ThinAuthorizationResponse> responses, AssociationResult associationResult, String decisionCacheDuration) {
        this.responses = responses;
        this.associationResult = associationResult;
        this.decisionCacheDuration = decisionCacheDuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<ThinAuthorizationResponse> getResponses() {
        return this.responses;
    }

    public AssociationResult getAssociationResult() {
        return this.associationResult;
    }

    public String getDecisionCacheDuration() {
        return this.decisionCacheDuration;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ThinAssociationAuthorizationResponse(");
        sb.append("super=").append(super.toString());
        sb.append("responses=").append(String.valueOf(this.responses));
        sb.append(", associationResult=").append(String.valueOf((Object)this.associationResult));
        sb.append(", decisionCacheDuration=").append(String.valueOf(this.decisionCacheDuration));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThinAssociationAuthorizationResponse)) {
            return false;
        }
        ThinAssociationAuthorizationResponse other = (ThinAssociationAuthorizationResponse)((Object)o);
        return Objects.equals(this.responses, other.responses) && Objects.equals((Object)this.associationResult, (Object)other.associationResult) && Objects.equals(this.decisionCacheDuration, other.decisionCacheDuration) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.responses == null ? 43 : this.responses.hashCode());
        result = result * 59 + (this.associationResult == null ? 43 : this.associationResult.hashCode());
        result = result * 59 + (this.decisionCacheDuration == null ? 43 : this.decisionCacheDuration.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AssociationResult implements BmcEnum
    {
        FailUnknown("FAIL_UNKNOWN"),
        FailBadRequest("FAIL_BAD_REQUEST"),
        FailMissingEndorse("FAIL_MISSING_ENDORSE"),
        FailMissingAdmit("FAIL_MISSING_ADMIT"),
        Success("SUCCESS");

        private final String value;
        private static Map<String, AssociationResult> map;

        private AssociationResult(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AssociationResult create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AssociationResult: " + key);
        }

        static {
            map = new HashMap<String, AssociationResult>();
            for (AssociationResult v : AssociationResult.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="responses")
        private List<ThinAuthorizationResponse> responses;
        @JsonProperty(value="associationResult")
        private AssociationResult associationResult;
        @JsonProperty(value="decisionCacheDuration")
        private String decisionCacheDuration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder responses(List<ThinAuthorizationResponse> responses) {
            this.responses = responses;
            this.__explicitlySet__.add("responses");
            return this;
        }

        public Builder associationResult(AssociationResult associationResult) {
            this.associationResult = associationResult;
            this.__explicitlySet__.add("associationResult");
            return this;
        }

        public Builder decisionCacheDuration(String decisionCacheDuration) {
            this.decisionCacheDuration = decisionCacheDuration;
            this.__explicitlySet__.add("decisionCacheDuration");
            return this;
        }

        public ThinAssociationAuthorizationResponse build() {
            ThinAssociationAuthorizationResponse model = new ThinAssociationAuthorizationResponse(this.responses, this.associationResult, this.decisionCacheDuration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ThinAssociationAuthorizationResponse model) {
            if (model.wasPropertyExplicitlySet("responses")) {
                this.responses(model.getResponses());
            }
            if (model.wasPropertyExplicitlySet("associationResult")) {
                this.associationResult(model.getAssociationResult());
            }
            if (model.wasPropertyExplicitlySet("decisionCacheDuration")) {
                this.decisionCacheDuration(model.getDecisionCacheDuration());
            }
            return this;
        }
    }
}

