/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BadUserStateAuthenticateUserResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tenantInput")
    private final String tenantInput;
    @JsonProperty(value="userInput")
    private final String userInput;
    @JsonProperty(value="resolvedTenantId")
    private final String resolvedTenantId;
    @JsonProperty(value="resolvedUserId")
    private final String resolvedUserId;
    @JsonProperty(value="userState")
    private final UserState userState;

    @Deprecated
    @ConstructorProperties(value={"tenantInput", "userInput", "resolvedTenantId", "resolvedUserId", "userState"})
    public BadUserStateAuthenticateUserResult(String tenantInput, String userInput, String resolvedTenantId, String resolvedUserId, UserState userState) {
        this.tenantInput = tenantInput;
        this.userInput = userInput;
        this.resolvedTenantId = resolvedTenantId;
        this.resolvedUserId = resolvedUserId;
        this.userState = userState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getTenantInput() {
        return this.tenantInput;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public String getResolvedTenantId() {
        return this.resolvedTenantId;
    }

    public String getResolvedUserId() {
        return this.resolvedUserId;
    }

    public UserState getUserState() {
        return this.userState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BadUserStateAuthenticateUserResult(");
        sb.append("super=").append(super.toString());
        sb.append("tenantInput=").append(String.valueOf(this.tenantInput));
        sb.append(", userInput=").append(String.valueOf(this.userInput));
        sb.append(", resolvedTenantId=").append(String.valueOf(this.resolvedTenantId));
        sb.append(", resolvedUserId=").append(String.valueOf(this.resolvedUserId));
        sb.append(", userState=").append(String.valueOf((Object)this.userState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BadUserStateAuthenticateUserResult)) {
            return false;
        }
        BadUserStateAuthenticateUserResult other = (BadUserStateAuthenticateUserResult)((Object)o);
        return Objects.equals(this.tenantInput, other.tenantInput) && Objects.equals(this.userInput, other.userInput) && Objects.equals(this.resolvedTenantId, other.resolvedTenantId) && Objects.equals(this.resolvedUserId, other.resolvedUserId) && Objects.equals((Object)this.userState, (Object)other.userState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tenantInput == null ? 43 : this.tenantInput.hashCode());
        result = result * 59 + (this.userInput == null ? 43 : this.userInput.hashCode());
        result = result * 59 + (this.resolvedTenantId == null ? 43 : this.resolvedTenantId.hashCode());
        result = result * 59 + (this.resolvedUserId == null ? 43 : this.resolvedUserId.hashCode());
        result = result * 59 + (this.userState == null ? 43 : this.userState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UserState implements BmcEnum
    {
        UserBlocked("USER_BLOCKED"),
        UserDisabled("USER_DISABLED"),
        OneTimePasswordExpired("ONE_TIME_PASSWORD_EXPIRED"),
        PasswordInvalid("PASSWORD_INVALID");

        private final String value;
        private static Map<String, UserState> map;

        private UserState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UserState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UserState: " + key);
        }

        static {
            map = new HashMap<String, UserState>();
            for (UserState v : UserState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tenantInput")
        private String tenantInput;
        @JsonProperty(value="userInput")
        private String userInput;
        @JsonProperty(value="resolvedTenantId")
        private String resolvedTenantId;
        @JsonProperty(value="resolvedUserId")
        private String resolvedUserId;
        @JsonProperty(value="userState")
        private UserState userState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tenantInput(String tenantInput) {
            this.tenantInput = tenantInput;
            this.__explicitlySet__.add("tenantInput");
            return this;
        }

        public Builder userInput(String userInput) {
            this.userInput = userInput;
            this.__explicitlySet__.add("userInput");
            return this;
        }

        public Builder resolvedTenantId(String resolvedTenantId) {
            this.resolvedTenantId = resolvedTenantId;
            this.__explicitlySet__.add("resolvedTenantId");
            return this;
        }

        public Builder resolvedUserId(String resolvedUserId) {
            this.resolvedUserId = resolvedUserId;
            this.__explicitlySet__.add("resolvedUserId");
            return this;
        }

        public Builder userState(UserState userState) {
            this.userState = userState;
            this.__explicitlySet__.add("userState");
            return this;
        }

        public BadUserStateAuthenticateUserResult build() {
            BadUserStateAuthenticateUserResult model = new BadUserStateAuthenticateUserResult(this.tenantInput, this.userInput, this.resolvedTenantId, this.resolvedUserId, this.userState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BadUserStateAuthenticateUserResult model) {
            if (model.wasPropertyExplicitlySet("tenantInput")) {
                this.tenantInput(model.getTenantInput());
            }
            if (model.wasPropertyExplicitlySet("userInput")) {
                this.userInput(model.getUserInput());
            }
            if (model.wasPropertyExplicitlySet("resolvedTenantId")) {
                this.resolvedTenantId(model.getResolvedTenantId());
            }
            if (model.wasPropertyExplicitlySet("resolvedUserId")) {
                this.resolvedUserId(model.getResolvedUserId());
            }
            if (model.wasPropertyExplicitlySet("userState")) {
                this.userState(model.getUserState());
            }
            return this;
        }
    }
}

