/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.identitydataplane.model.Tenant;
import com.oracle.bmc.identitydataplane.model.User;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AuthenticationPrincipal
extends ExplicitlySetBmcModel {
    @JsonProperty(value="tenant")
    private final Tenant tenant;
    @JsonProperty(value="user")
    private final User user;

    @Deprecated
    @ConstructorProperties(value={"tenant", "user"})
    public AuthenticationPrincipal(Tenant tenant, User user) {
        this.tenant = tenant;
        this.user = user;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public User getUser() {
        return this.user;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthenticationPrincipal(");
        sb.append("super=").append(super.toString());
        sb.append("tenant=").append(String.valueOf((Object)this.tenant));
        sb.append(", user=").append(String.valueOf((Object)this.user));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticationPrincipal)) {
            return false;
        }
        AuthenticationPrincipal other = (AuthenticationPrincipal)((Object)o);
        return Objects.equals((Object)this.tenant, (Object)other.tenant) && Objects.equals((Object)this.user, (Object)other.user) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.tenant == null ? 43 : this.tenant.hashCode());
        result = result * 59 + (this.user == null ? 43 : this.user.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="tenant")
        private Tenant tenant;
        @JsonProperty(value="user")
        private User user;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder tenant(Tenant tenant) {
            this.tenant = tenant;
            this.__explicitlySet__.add("tenant");
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            this.__explicitlySet__.add("user");
            return this;
        }

        public AuthenticationPrincipal build() {
            AuthenticationPrincipal model = new AuthenticationPrincipal(this.tenant, this.user);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AuthenticationPrincipal model) {
            if (model.wasPropertyExplicitlySet("tenant")) {
                this.tenant(model.getTenant());
            }
            if (model.wasPropertyExplicitlySet("user")) {
                this.user(model.getUser());
            }
            return this;
        }
    }
}

