/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identitydataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.identitydataplane.model.AuthorizationRequest;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AccessibleCompartmentRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="authorizationRequest")
    private final AuthorizationRequest authorizationRequest;
    @JsonProperty(value="compartmentIds")
    private final List<String> compartmentIds;

    @Deprecated
    @ConstructorProperties(value={"authorizationRequest", "compartmentIds"})
    public AccessibleCompartmentRequest(AuthorizationRequest authorizationRequest, List<String> compartmentIds) {
        this.authorizationRequest = authorizationRequest;
        this.compartmentIds = compartmentIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AuthorizationRequest getAuthorizationRequest() {
        return this.authorizationRequest;
    }

    public List<String> getCompartmentIds() {
        return this.compartmentIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessibleCompartmentRequest(");
        sb.append("super=").append(super.toString());
        sb.append("authorizationRequest=").append(String.valueOf((Object)this.authorizationRequest));
        sb.append(", compartmentIds=").append(String.valueOf(this.compartmentIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessibleCompartmentRequest)) {
            return false;
        }
        AccessibleCompartmentRequest other = (AccessibleCompartmentRequest)((Object)o);
        return Objects.equals((Object)this.authorizationRequest, (Object)other.authorizationRequest) && Objects.equals(this.compartmentIds, other.compartmentIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.authorizationRequest == null ? 43 : this.authorizationRequest.hashCode());
        result = result * 59 + (this.compartmentIds == null ? 43 : this.compartmentIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="authorizationRequest")
        private AuthorizationRequest authorizationRequest;
        @JsonProperty(value="compartmentIds")
        private List<String> compartmentIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder authorizationRequest(AuthorizationRequest authorizationRequest) {
            this.authorizationRequest = authorizationRequest;
            this.__explicitlySet__.add("authorizationRequest");
            return this;
        }

        public Builder compartmentIds(List<String> compartmentIds) {
            this.compartmentIds = compartmentIds;
            this.__explicitlySet__.add("compartmentIds");
            return this;
        }

        public AccessibleCompartmentRequest build() {
            AccessibleCompartmentRequest model = new AccessibleCompartmentRequest(this.authorizationRequest, this.compartmentIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AccessibleCompartmentRequest model) {
            if (model.wasPropertyExplicitlySet("authorizationRequest")) {
                this.authorizationRequest(model.getAuthorizationRequest());
            }
            if (model.wasPropertyExplicitlySet("compartmentIds")) {
                this.compartmentIds(model.getCompartmentIds());
            }
            return this;
        }
    }
}

