/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.governancerulescontrolplane.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTenancyAttachmentRequest
extends BmcRequest<Void> {
    private String tenancyAttachmentId;
    private String opcRequestId;

    public String getTenancyAttachmentId() {
        return this.tenancyAttachmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().tenancyAttachmentId(this.tenancyAttachmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tenancyAttachmentId=").append(String.valueOf(this.tenancyAttachmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTenancyAttachmentRequest)) {
            return false;
        }
        GetTenancyAttachmentRequest other = (GetTenancyAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tenancyAttachmentId, other.tenancyAttachmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tenancyAttachmentId == null ? 43 : this.tenancyAttachmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTenancyAttachmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tenancyAttachmentId = null;
        private String opcRequestId = null;

        public Builder tenancyAttachmentId(String tenancyAttachmentId) {
            this.tenancyAttachmentId = tenancyAttachmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTenancyAttachmentRequest o) {
            this.tenancyAttachmentId(o.getTenancyAttachmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTenancyAttachmentRequest build() {
            GetTenancyAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTenancyAttachmentRequest buildWithoutInvocationCallback() {
            GetTenancyAttachmentRequest request = new GetTenancyAttachmentRequest();
            request.tenancyAttachmentId = this.tenancyAttachmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

