/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.governancerulescontrolplane.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetInclusionCriterionRequest
extends BmcRequest<Void> {
    private String inclusionCriterionId;
    private String opcRequestId;

    public String getInclusionCriterionId() {
        return this.inclusionCriterionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().inclusionCriterionId(this.inclusionCriterionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",inclusionCriterionId=").append(String.valueOf(this.inclusionCriterionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetInclusionCriterionRequest)) {
            return false;
        }
        GetInclusionCriterionRequest other = (GetInclusionCriterionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.inclusionCriterionId, other.inclusionCriterionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.inclusionCriterionId == null ? 43 : this.inclusionCriterionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInclusionCriterionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String inclusionCriterionId = null;
        private String opcRequestId = null;

        public Builder inclusionCriterionId(String inclusionCriterionId) {
            this.inclusionCriterionId = inclusionCriterionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInclusionCriterionRequest o) {
            this.inclusionCriterionId(o.getInclusionCriterionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInclusionCriterionRequest build() {
            GetInclusionCriterionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetInclusionCriterionRequest buildWithoutInvocationCallback() {
            GetInclusionCriterionRequest request = new GetInclusionCriterionRequest();
            request.inclusionCriterionId = this.inclusionCriterionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

