/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.governancerulescontrolplane.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetEnforcedGovernanceRuleRequest
extends BmcRequest<Void> {
    private String enforcedGovernanceRuleId;
    private String opcRequestId;

    public String getEnforcedGovernanceRuleId() {
        return this.enforcedGovernanceRuleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().enforcedGovernanceRuleId(this.enforcedGovernanceRuleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",enforcedGovernanceRuleId=").append(String.valueOf(this.enforcedGovernanceRuleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEnforcedGovernanceRuleRequest)) {
            return false;
        }
        GetEnforcedGovernanceRuleRequest other = (GetEnforcedGovernanceRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.enforcedGovernanceRuleId, other.enforcedGovernanceRuleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.enforcedGovernanceRuleId == null ? 43 : this.enforcedGovernanceRuleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEnforcedGovernanceRuleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String enforcedGovernanceRuleId = null;
        private String opcRequestId = null;

        public Builder enforcedGovernanceRuleId(String enforcedGovernanceRuleId) {
            this.enforcedGovernanceRuleId = enforcedGovernanceRuleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEnforcedGovernanceRuleRequest o) {
            this.enforcedGovernanceRuleId(o.getEnforcedGovernanceRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEnforcedGovernanceRuleRequest build() {
            GetEnforcedGovernanceRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetEnforcedGovernanceRuleRequest buildWithoutInvocationCallback() {
            GetEnforcedGovernanceRuleRequest request = new GetEnforcedGovernanceRuleRequest();
            request.enforcedGovernanceRuleId = this.enforcedGovernanceRuleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

