/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConnectionAssignmentRequest
extends BmcRequest<Void> {
    private String connectionAssignmentId;
    private String opcRequestId;

    public String getConnectionAssignmentId() {
        return this.connectionAssignmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().connectionAssignmentId(this.connectionAssignmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",connectionAssignmentId=").append(String.valueOf(this.connectionAssignmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConnectionAssignmentRequest)) {
            return false;
        }
        GetConnectionAssignmentRequest other = (GetConnectionAssignmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.connectionAssignmentId, other.connectionAssignmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.connectionAssignmentId == null ? 43 : this.connectionAssignmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConnectionAssignmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String connectionAssignmentId = null;
        private String opcRequestId = null;

        public Builder connectionAssignmentId(String connectionAssignmentId) {
            this.connectionAssignmentId = connectionAssignmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConnectionAssignmentRequest o) {
            this.connectionAssignmentId(o.getConnectionAssignmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConnectionAssignmentRequest build() {
            GetConnectionAssignmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConnectionAssignmentRequest buildWithoutInvocationCallback() {
            GetConnectionAssignmentRequest request = new GetConnectionAssignmentRequest();
            request.connectionAssignmentId = this.connectionAssignmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

