/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MessageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="deploymentMessage")
    private final String deploymentMessage;
    @JsonProperty(value="deploymentMessageStatus")
    private final DeploymentMessageStatus deploymentMessageStatus;

    @Deprecated
    @ConstructorProperties(value={"id", "deploymentMessage", "deploymentMessageStatus"})
    public MessageSummary(String id, String deploymentMessage, DeploymentMessageStatus deploymentMessageStatus) {
        this.id = id;
        this.deploymentMessage = deploymentMessage;
        this.deploymentMessageStatus = deploymentMessageStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDeploymentMessage() {
        return this.deploymentMessage;
    }

    public DeploymentMessageStatus getDeploymentMessageStatus() {
        return this.deploymentMessageStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", deploymentMessage=").append(String.valueOf(this.deploymentMessage));
        sb.append(", deploymentMessageStatus=").append(String.valueOf((Object)this.deploymentMessageStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageSummary)) {
            return false;
        }
        MessageSummary other = (MessageSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.deploymentMessage, other.deploymentMessage) && Objects.equals((Object)this.deploymentMessageStatus, (Object)other.deploymentMessageStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.deploymentMessage == null ? 43 : this.deploymentMessage.hashCode());
        result = result * 59 + (this.deploymentMessageStatus == null ? 43 : this.deploymentMessageStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DeploymentMessageStatus implements BmcEnum
    {
        Info("INFO"),
        Warning("WARNING"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DeploymentMessageStatus> map;

        private DeploymentMessageStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DeploymentMessageStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DeploymentMessageStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DeploymentMessageStatus.class);
            map = new HashMap<String, DeploymentMessageStatus>();
            for (DeploymentMessageStatus v : DeploymentMessageStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="deploymentMessage")
        private String deploymentMessage;
        @JsonProperty(value="deploymentMessageStatus")
        private DeploymentMessageStatus deploymentMessageStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder deploymentMessage(String deploymentMessage) {
            this.deploymentMessage = deploymentMessage;
            this.__explicitlySet__.add("deploymentMessage");
            return this;
        }

        public Builder deploymentMessageStatus(DeploymentMessageStatus deploymentMessageStatus) {
            this.deploymentMessageStatus = deploymentMessageStatus;
            this.__explicitlySet__.add("deploymentMessageStatus");
            return this;
        }

        public MessageSummary build() {
            MessageSummary model = new MessageSummary(this.id, this.deploymentMessage, this.deploymentMessageStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MessageSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("deploymentMessage")) {
                this.deploymentMessage(model.getDeploymentMessage());
            }
            if (model.wasPropertyExplicitlySet("deploymentMessageStatus")) {
                this.deploymentMessageStatus(model.getDeploymentMessageStatus());
            }
            return this;
        }
    }
}

