/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.genericartifactscontent.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class PutGenericArtifactContentByPathRequest
extends BmcRequest<InputStream> {
    private String repositoryId;
    private String artifactPath;
    private String version;
    private InputStream genericArtifactContentBody;
    private String ifMatch;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public String getVersion() {
        return this.version;
    }

    public InputStream getGenericArtifactContentBody() {
        return this.genericArtifactContentBody;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.genericArtifactContentBody;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).artifactPath(this.artifactPath).version(this.version).genericArtifactContentBody(this.genericArtifactContentBody).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",artifactPath=").append(String.valueOf(this.artifactPath));
        sb.append(",version=").append(String.valueOf(this.version));
        sb.append(",genericArtifactContentBody=").append(String.valueOf(this.genericArtifactContentBody));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutGenericArtifactContentByPathRequest)) {
            return false;
        }
        PutGenericArtifactContentByPathRequest other = (PutGenericArtifactContentByPathRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.artifactPath, other.artifactPath) && Objects.equals(this.version, other.version) && Objects.equals(this.genericArtifactContentBody, other.genericArtifactContentBody) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.artifactPath == null ? 43 : this.artifactPath.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.genericArtifactContentBody == null ? 43 : this.genericArtifactContentBody.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PutGenericArtifactContentByPathRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private String artifactPath = null;
        private String version = null;
        private InputStream genericArtifactContentBody = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder artifactPath(String artifactPath) {
            this.artifactPath = artifactPath;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder genericArtifactContentBody(InputStream genericArtifactContentBody) {
            this.genericArtifactContentBody = genericArtifactContentBody;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PutGenericArtifactContentByPathRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.artifactPath(o.getArtifactPath());
            this.version(o.getVersion());
            this.genericArtifactContentBody(o.getGenericArtifactContentBody());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PutGenericArtifactContentByPathRequest build() {
            PutGenericArtifactContentByPathRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.genericArtifactContentBody(body);
            return this;
        }

        public PutGenericArtifactContentByPathRequest buildWithoutInvocationCallback() {
            PutGenericArtifactContentByPathRequest request = new PutGenericArtifactContentByPathRequest();
            request.repositoryId = this.repositoryId;
            request.artifactPath = this.artifactPath;
            request.version = this.version;
            request.genericArtifactContentBody = this.genericArtifactContentBody;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

