/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.genericartifactscontent;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.genericartifactscontent.GenericArtifactsContentAsync;
import com.oracle.bmc.genericartifactscontent.model.GenericArtifact;
import com.oracle.bmc.genericartifactscontent.requests.GetGenericArtifactContentByPathRequest;
import com.oracle.bmc.genericartifactscontent.requests.GetGenericArtifactContentRequest;
import com.oracle.bmc.genericartifactscontent.requests.PutGenericArtifactContentByPathRequest;
import com.oracle.bmc.genericartifactscontent.responses.GetGenericArtifactContentByPathResponse;
import com.oracle.bmc.genericartifactscontent.responses.GetGenericArtifactContentResponse;
import com.oracle.bmc.genericartifactscontent.responses.PutGenericArtifactContentByPathResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericArtifactsContentAsyncClient
extends BaseAsyncClient
implements GenericArtifactsContentAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("GENERICARTIFACTSCONTENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://generic.artifacts.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(GenericArtifactsContentAsyncClient.class);

    private GenericArtifactsContentAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetGenericArtifactContentResponse> getGenericArtifactContent(GetGenericArtifactContentRequest request, AsyncHandler<GetGenericArtifactContentRequest, GetGenericArtifactContentResponse> handler) {
        Validate.notBlank((String)request.getArtifactId(), (String)"artifactId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetGenericArtifactContentResponse::builder).logger(LOG, "getGenericArtifactContent").serviceDetails("GenericArtifactsContent", "GetGenericArtifactContent", "https://docs.oracle.com/iaas/api/#/en/generic/20160918/GenericArtifact/GetGenericArtifactContent").method(Method.GET).requestBuilder(GetGenericArtifactContentRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("artifacts").appendPathParam(request.getArtifactId()).appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetGenericArtifactContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetGenericArtifactContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGenericArtifactContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetGenericArtifactContentByPathResponse> getGenericArtifactContentByPath(GetGenericArtifactContentByPathRequest request, AsyncHandler<GetGenericArtifactContentByPathRequest, GetGenericArtifactContentByPathResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getArtifactPath(), (String)"artifactPath must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVersion(), (String)"version must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetGenericArtifactContentByPathResponse::builder).logger(LOG, "getGenericArtifactContentByPath").serviceDetails("GenericArtifactsContent", "GetGenericArtifactContentByPath", "https://docs.oracle.com/iaas/api/#/en/generic/20160918/GenericArtifact/GetGenericArtifactContentByPath").method(Method.GET).requestBuilder(GetGenericArtifactContentByPathRequest::builder).basePath("/20160918").appendPathParam("generic").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("artifactPaths").appendPathParam(request.getArtifactPath()).appendPathParam("versions").appendPathParam(request.getVersion()).appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetGenericArtifactContentByPathResponse.Builder::inputStream).handleResponseHeaderString("etag", GetGenericArtifactContentByPathResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGenericArtifactContentByPathResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<PutGenericArtifactContentByPathResponse> putGenericArtifactContentByPath(PutGenericArtifactContentByPathRequest request, AsyncHandler<PutGenericArtifactContentByPathRequest, PutGenericArtifactContentByPathResponse> handler) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getArtifactPath(), (String)"artifactPath must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getVersion(), (String)"version must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGenericArtifactContentBody(), "genericArtifactContentBody is required");
        return this.clientCall(request, PutGenericArtifactContentByPathResponse::builder).logger(LOG, "putGenericArtifactContentByPath").serviceDetails("GenericArtifactsContent", "PutGenericArtifactContentByPath", "https://docs.oracle.com/iaas/api/#/en/generic/20160918/GenericArtifact/PutGenericArtifactContentByPath").method(Method.PUT).requestBuilder(PutGenericArtifactContentByPathRequest::builder).obmcsSigningStrategy(SigningStrategy.EXCLUDE_BODY).basePath("/20160918").appendPathParam("generic").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("artifactPaths").appendPathParam(request.getArtifactPath()).appendPathParam("versions").appendPathParam(request.getVersion()).appendPathParam("content").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBinaryRequestBody().hasBody().handleBody(GenericArtifact.class, PutGenericArtifactContentByPathResponse.Builder::genericArtifact).handleResponseHeaderString("etag", PutGenericArtifactContentByPathResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PutGenericArtifactContentByPathResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public GenericArtifactsContentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)GenericArtifactsContentAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenericArtifactsContentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(GenericArtifactsContentAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenericArtifactsContentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)GenericArtifactsContentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public GenericArtifactsContentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)GenericArtifactsContentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public GenericArtifactsContentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)GenericArtifactsContentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public GenericArtifactsContentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)GenericArtifactsContentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public GenericArtifactsContentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)GenericArtifactsContentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, GenericArtifactsContentAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public GenericArtifactsContentAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new GenericArtifactsContentAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

