/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.generativeaiinference.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ImageUrl
extends ExplicitlySetBmcModel {
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="detail")
    private final Detail detail;

    @Deprecated
    @ConstructorProperties(value={"url", "detail"})
    public ImageUrl(String url, Detail detail) {
        this.url = url;
        this.detail = detail;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUrl() {
        return this.url;
    }

    public Detail getDetail() {
        return this.detail;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImageUrl(");
        sb.append("super=").append(super.toString());
        sb.append("url=").append(String.valueOf(this.url));
        sb.append(", detail=").append(String.valueOf((Object)this.detail));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageUrl)) {
            return false;
        }
        ImageUrl other = (ImageUrl)((Object)o);
        return Objects.equals(this.url, other.url) && Objects.equals((Object)this.detail, (Object)other.detail) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.detail == null ? 43 : this.detail.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Detail implements BmcEnum
    {
        Auto("AUTO"),
        High("HIGH"),
        Low("LOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Detail> map;

        private Detail(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Detail create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Detail', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Detail.class);
            map = new HashMap<String, Detail>();
            for (Detail v : Detail.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="detail")
        private Detail detail;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder detail(Detail detail) {
            this.detail = detail;
            this.__explicitlySet__.add("detail");
            return this;
        }

        public ImageUrl build() {
            ImageUrl model = new ImageUrl(this.url, this.detail);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImageUrl model) {
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("detail")) {
                this.detail(model.getDetail());
            }
            return this;
        }
    }
}

