/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.functions;

import com.oracle.bmc.functions.FunctionsManagement;
import com.oracle.bmc.functions.model.ApplicationSummary;
import com.oracle.bmc.functions.model.FunctionSummary;
import com.oracle.bmc.functions.requests.ListApplicationsRequest;
import com.oracle.bmc.functions.requests.ListFunctionsRequest;
import com.oracle.bmc.functions.responses.ListApplicationsResponse;
import com.oracle.bmc.functions.responses.ListFunctionsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class FunctionsManagementPaginators {
    private final FunctionsManagement client;

    public FunctionsManagementPaginators(FunctionsManagement client) {
        this.client = client;
    }

    public Iterable<ListApplicationsResponse> listApplicationsResponseIterator(final ListApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            @Override
            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            @Override
            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            @Override
            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            @Override
            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return FunctionsManagementPaginators.this.client.listApplications(request);
            }
        });
    }

    public Iterable<ApplicationSummary> listApplicationsRecordIterator(final ListApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            @Override
            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            @Override
            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            @Override
            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            @Override
            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return FunctionsManagementPaginators.this.client.listApplications(request);
            }
        }, (Function)new Function<ListApplicationsResponse, List<ApplicationSummary>>(){

            @Override
            public List<ApplicationSummary> apply(ListApplicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListFunctionsResponse> listFunctionsResponseIterator(final ListFunctionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListFunctionsRequest.Builder>(){

            @Override
            public ListFunctionsRequest.Builder get() {
                return ListFunctionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFunctionsResponse, String>(){

            @Override
            public String apply(ListFunctionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFunctionsRequest.Builder>, ListFunctionsRequest>(){

            @Override
            public ListFunctionsRequest apply(RequestBuilderAndToken<ListFunctionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFunctionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFunctionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFunctionsRequest, ListFunctionsResponse>(){

            @Override
            public ListFunctionsResponse apply(ListFunctionsRequest request) {
                return FunctionsManagementPaginators.this.client.listFunctions(request);
            }
        });
    }

    public Iterable<FunctionSummary> listFunctionsRecordIterator(final ListFunctionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListFunctionsRequest.Builder>(){

            @Override
            public ListFunctionsRequest.Builder get() {
                return ListFunctionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFunctionsResponse, String>(){

            @Override
            public String apply(ListFunctionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFunctionsRequest.Builder>, ListFunctionsRequest>(){

            @Override
            public ListFunctionsRequest apply(RequestBuilderAndToken<ListFunctionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFunctionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFunctionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFunctionsRequest, ListFunctionsResponse>(){

            @Override
            public ListFunctionsResponse apply(ListFunctionsRequest request) {
                return FunctionsManagementPaginators.this.client.listFunctions(request);
            }
        }, (Function)new Function<ListFunctionsResponse, List<FunctionSummary>>(){

            @Override
            public List<FunctionSummary> apply(ListFunctionsResponse response) {
                return response.getItems();
            }
        });
    }
}

