/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events;

import com.oracle.bmc.events.Events;
import com.oracle.bmc.events.model.RuleSummary;
import com.oracle.bmc.events.requests.ListRulesRequest;
import com.oracle.bmc.events.responses.ListRulesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class EventsPaginators {
    private final Events client;

    public EventsPaginators(Events client) {
        this.client = client;
    }

    public Iterable<ListRulesResponse> listRulesResponseIterator(final ListRulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRulesRequest.Builder>(){

            @Override
            public ListRulesRequest.Builder get() {
                return ListRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRulesResponse, String>(){

            @Override
            public String apply(ListRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRulesRequest.Builder>, ListRulesRequest>(){

            @Override
            public ListRulesRequest apply(RequestBuilderAndToken<ListRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRulesRequest, ListRulesResponse>(){

            @Override
            public ListRulesResponse apply(ListRulesRequest request) {
                return EventsPaginators.this.client.listRules(request);
            }
        });
    }

    public Iterable<RuleSummary> listRulesRecordIterator(final ListRulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRulesRequest.Builder>(){

            @Override
            public ListRulesRequest.Builder get() {
                return ListRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRulesResponse, String>(){

            @Override
            public String apply(ListRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRulesRequest.Builder>, ListRulesRequest>(){

            @Override
            public ListRulesRequest apply(RequestBuilderAndToken<ListRulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRulesRequest, ListRulesResponse>(){

            @Override
            public ListRulesResponse apply(ListRulesRequest request) {
                return EventsPaginators.this.client.listRules(request);
            }
        }, (Function)new Function<ListRulesResponse, List<RuleSummary>>(){

            @Override
            public List<RuleSummary> apply(ListRulesResponse response) {
                return response.getItems();
            }
        });
    }
}

