/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.oracle.bmc.auth.internal.AuthUtils;
import com.oracle.bmc.encryption.internal.EncryptionKey;
import com.oracle.bmc.http.client.Serialization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EncryptionHeader {
    private String additionalAuthenticatedData;
    private List<EncryptionKey> encryptedDataKeys = new ArrayList<EncryptionKey>();
    private String iv;
    private byte[] headerBytes;

    public void setEncryptionHeader(EncryptionKey encryptionKey, String iv, String additionalAuthenticatedData) {
        this.encryptedDataKeys.add(encryptionKey);
        this.iv = iv;
        this.additionalAuthenticatedData = additionalAuthenticatedData;
    }

    @JsonIgnore
    public byte[] getIvBytes() {
        return AuthUtils.base64Decode((String)this.iv);
    }

    @JsonIgnore
    public byte[] getHeaderBytes() {
        return this.headerBytes;
    }

    public void setHeaderBytes(byte[] headerBytes) {
        this.headerBytes = headerBytes;
    }

    public String getAdditionalAuthenticatedData() {
        return this.additionalAuthenticatedData;
    }

    @JsonIgnore
    public Map<String, String> getContext() throws JsonProcessingException {
        if (this.additionalAuthenticatedData.isEmpty()) {
            return new HashMap<String, String>();
        }
        Map result = (Map)Serialization.getObjectMapper().readValue(this.additionalAuthenticatedData, HashMap.class);
        return result;
    }

    @JsonIgnore
    public EncryptionKey getEncryptionKey() {
        return this.encryptedDataKeys.get(0);
    }

    public List<EncryptionKey> getEncryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public String getIV() {
        return this.iv;
    }
}

