/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption.internal;

import com.oracle.bmc.encryption.OciCryptoInputStream;
import com.oracle.bmc.encryption.internal.EncryptionHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class DecryptionStream
extends OciCryptoInputStream {
    private final Cipher cipher;
    private final InputStream inputStream;
    private boolean isInputStreamDecrypted = false;
    private InputStream decryptInputStream;

    public DecryptionStream(InputStream inputStream, Cipher cipher, EncryptionHeader header) {
        super(header);
        this.inputStream = inputStream;
        this.cipher = cipher;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!this.isInputStreamDecrypted) {
            byte[] result = this.decrypt();
            this.decryptInputStream = new ByteArrayInputStream(result);
            this.isInputStreamDecrypted = true;
        }
        return this.decryptInputStream.read(b);
    }

    protected byte[] decrypt() throws IOException {
        ByteArrayOutputStream bBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        int length = 0;
        try {
            while ((length = this.inputStream.read(buffer)) != -1) {
                bBuffer.write(buffer, 0, length);
            }
            return this.cipher.doFinal(bBuffer.toByteArray());
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Failed to decrypt the data. ", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.decryptInputStream != null) {
            this.decryptInputStream.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

