/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.encryption;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.encryption.MasterKey;
import com.oracle.bmc.encryption.internal.CryptoAlgorithm;
import com.oracle.bmc.encryption.internal.DataKey;
import com.oracle.bmc.keymanagement.KmsCryptoClient;
import com.oracle.bmc.keymanagement.KmsManagementClient;
import com.oracle.bmc.keymanagement.KmsVaultClient;
import com.oracle.bmc.keymanagement.model.DecryptDataDetails;
import com.oracle.bmc.keymanagement.model.GenerateKeyDetails;
import com.oracle.bmc.keymanagement.model.KeyShape;
import com.oracle.bmc.keymanagement.model.Vault;
import com.oracle.bmc.keymanagement.requests.DecryptRequest;
import com.oracle.bmc.keymanagement.requests.GenerateDataEncryptionKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.responses.DecryptResponse;
import com.oracle.bmc.keymanagement.responses.GenerateDataEncryptionKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.model.BmcException;

public class KmsMasterKey
implements MasterKey {
    private final KmsCryptoClient kmsCryptoClient;
    private final KmsManagementClient kmsManagementClient;
    private final KmsVaultClient kmsVaultClient;
    private final BasicAuthenticationDetailsProvider provider;
    private final String vaultId;
    private final String kmsMasterKeyId;
    private final String region;

    public KmsMasterKey(BasicAuthenticationDetailsProvider authenticationDetailsProvider, String region, String vaultId, String kmsMasterKeyId) {
        if (authenticationDetailsProvider == null || region.isEmpty()) {
            throw new IllegalArgumentException("Please provide a valid authenticationDetailsProvider and a region.");
        }
        if (vaultId.isEmpty() || kmsMasterKeyId.isEmpty()) {
            throw new IllegalArgumentException("Encryption Key info is missing. Please provide a kmsMasterKeyId and vaultId.");
        }
        this.vaultId = vaultId;
        this.kmsMasterKeyId = kmsMasterKeyId;
        this.region = region;
        this.provider = authenticationDetailsProvider;
        this.kmsVaultClient = new KmsVaultClient(this.provider);
        this.kmsManagementClient = new KmsManagementClient(this.provider);
        this.kmsCryptoClient = new KmsCryptoClient(this.provider);
        this.kmsVaultClient.setRegion(region);
        this.setVault(vaultId);
    }

    private void setVault(String vaultId) {
        GetVaultResponse response;
        GetVaultRequest getVaultRequest = GetVaultRequest.builder().vaultId(vaultId).build();
        try {
            response = this.kmsVaultClient.getVault(getVaultRequest);
        }
        catch (BmcException e) {
            throw new RuntimeException(this.getVaultAccessErrorMsg(), e);
        }
        Vault vault = response.getVault();
        this.kmsManagementClient.setEndpoint(vault.getManagementEndpoint());
        this.kmsCryptoClient.setEndpoint(vault.getCryptoEndpoint());
    }

    @Override
    public DataKey generateDataEncryptionKey(CryptoAlgorithm cryptoAlgorithm) {
        GenerateDataEncryptionKeyResponse response;
        KeyShape masterkeyShape = KeyShape.builder().algorithm(KeyShape.Algorithm.Aes).length(Integer.valueOf(cryptoAlgorithm.getDataKeyLen())).build();
        GenerateKeyDetails generateKeyDetails = GenerateKeyDetails.builder().keyId(this.kmsMasterKeyId).keyShape(masterkeyShape).includePlaintextKey(Boolean.valueOf(true)).build();
        GenerateDataEncryptionKeyRequest generateDataEncryptionKeyRequest = GenerateDataEncryptionKeyRequest.builder().generateKeyDetails(generateKeyDetails).build();
        try {
            response = this.kmsCryptoClient.generateDataEncryptionKey(generateDataEncryptionKeyRequest);
        }
        catch (BmcException generateKeyError) {
            try {
                GetKeyRequest getKeyRequest = GetKeyRequest.builder().keyId(this.kmsMasterKeyId).build();
                GetKeyResponse getKeyResponse = this.kmsManagementClient.getKey(getKeyRequest);
            }
            catch (BmcException keyError) {
                throw new RuntimeException(this.getMasterKeyAccessErrorMsg(), keyError);
            }
            throw new RuntimeException("Can't generate the DataKey using MasterKeyId: " + this.kmsMasterKeyId, generateKeyError);
        }
        DataKey dataKey = new DataKey(response.getGeneratedKey().getCiphertext(), response.getGeneratedKey().getPlaintext(), response.getGeneratedKey().getPlaintextChecksum());
        return dataKey;
    }

    @Override
    public String decryptDataKey(String encryptedDataKey, String kmsMasterKeyId) {
        DecryptResponse response;
        DecryptDataDetails decryptDataDetails = DecryptDataDetails.builder().ciphertext(encryptedDataKey).keyId(kmsMasterKeyId).build();
        DecryptRequest decryptRequest = DecryptRequest.builder().decryptDataDetails(decryptDataDetails).build();
        try {
            response = this.kmsCryptoClient.decrypt(decryptRequest);
        }
        catch (BmcException decryptError) {
            try {
                GetKeyRequest getKeyRequest = GetKeyRequest.builder().keyId(kmsMasterKeyId).build();
                GetKeyResponse getKeyResponse = this.kmsManagementClient.getKey(getKeyRequest);
            }
            catch (BmcException keyError) {
                throw new RuntimeException(this.getMasterKeyAccessErrorMsg(), keyError);
            }
            throw new RuntimeException("Can't decrypt the DataKey using MasterKeyId: " + kmsMasterKeyId, decryptError);
        }
        return response.getDecryptedData().getPlaintext();
    }

    private String getMasterKeyAccessErrorMsg() {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("Failed to access MasterKeyId: ");
        errorMsg.append(this.kmsMasterKeyId);
        errorMsg.append(" in vaultId: ");
        errorMsg.append(this.vaultId);
        errorMsg.append(" in region: ");
        errorMsg.append(this.region);
        return errorMsg.toString();
    }

    private String getVaultAccessErrorMsg() {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("Failed to access vaultId: ");
        errorMsg.append(this.vaultId);
        errorMsg.append(" in region: ");
        errorMsg.append(this.region);
        return errorMsg.toString();
    }

    public void close() {
        if (this.kmsVaultClient != null) {
            this.kmsVaultClient.close();
        }
        if (this.kmsManagementClient != null) {
            this.kmsManagementClient.close();
        }
        if (this.kmsCryptoClient != null) {
            this.kmsCryptoClient.close();
        }
    }

    public BasicAuthenticationDetailsProvider getProvider() {
        return this.provider;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getKmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public String getRegion() {
        return this.region;
    }
}

