/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDkimRequest
extends BmcRequest<Void> {
    private String dkimId;
    private String opcRequestId;

    public String getDkimId() {
        return this.dkimId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dkimId(this.dkimId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dkimId=").append(String.valueOf(this.dkimId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDkimRequest)) {
            return false;
        }
        GetDkimRequest other = (GetDkimRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dkimId, other.dkimId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dkimId == null ? 43 : this.dkimId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDkimRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dkimId = null;
        private String opcRequestId = null;

        public Builder dkimId(String dkimId) {
            this.dkimId = dkimId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDkimRequest o) {
            this.dkimId(o.getDkimId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDkimRequest build() {
            GetDkimRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDkimRequest buildWithoutInvocationCallback() {
            GetDkimRequest request = new GetDkimRequest();
            request.dkimId = this.dkimId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

