/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Suppression
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="emailAddress")
    private final String emailAddress;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="reason")
    private final Reason reason;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastSuppressed")
    private final Date timeLastSuppressed;
    @JsonProperty(value="messageId")
    private final String messageId;
    @JsonProperty(value="errorDetail")
    private final String errorDetail;
    @JsonProperty(value="errorSource")
    private final String errorSource;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "emailAddress", "id", "reason", "timeCreated", "timeLastSuppressed", "messageId", "errorDetail", "errorSource"})
    public Suppression(String compartmentId, String emailAddress, String id, Reason reason, Date timeCreated, Date timeLastSuppressed, String messageId, String errorDetail, String errorSource) {
        this.compartmentId = compartmentId;
        this.emailAddress = emailAddress;
        this.id = id;
        this.reason = reason;
        this.timeCreated = timeCreated;
        this.timeLastSuppressed = timeLastSuppressed;
        this.messageId = messageId;
        this.errorDetail = errorDetail;
        this.errorSource = errorSource;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getId() {
        return this.id;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastSuppressed() {
        return this.timeLastSuppressed;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public String getErrorSource() {
        return this.errorSource;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Suppression(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", emailAddress=").append(String.valueOf(this.emailAddress));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", reason=").append(String.valueOf((Object)this.reason));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastSuppressed=").append(String.valueOf(this.timeLastSuppressed));
        sb.append(", messageId=").append(String.valueOf(this.messageId));
        sb.append(", errorDetail=").append(String.valueOf(this.errorDetail));
        sb.append(", errorSource=").append(String.valueOf(this.errorSource));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Suppression)) {
            return false;
        }
        Suppression other = (Suppression)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.reason, (Object)other.reason) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastSuppressed, other.timeLastSuppressed) && Objects.equals(this.messageId, other.messageId) && Objects.equals(this.errorDetail, other.errorDetail) && Objects.equals(this.errorSource, other.errorSource) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.emailAddress == null ? 43 : this.emailAddress.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.reason == null ? 43 : this.reason.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastSuppressed == null ? 43 : this.timeLastSuppressed.hashCode());
        result = result * 59 + (this.messageId == null ? 43 : this.messageId.hashCode());
        result = result * 59 + (this.errorDetail == null ? 43 : this.errorDetail.hashCode());
        result = result * 59 + (this.errorSource == null ? 43 : this.errorSource.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Reason implements BmcEnum
    {
        Unknown("UNKNOWN"),
        Hardbounce("HARDBOUNCE"),
        Complaint("COMPLAINT"),
        Manual("MANUAL"),
        Softbounce("SOFTBOUNCE"),
        Unsubscribe("UNSUBSCRIBE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Reason> map;

        private Reason(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Reason create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Reason', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Reason.class);
            map = new HashMap<String, Reason>();
            for (Reason v : Reason.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="emailAddress")
        private String emailAddress;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="reason")
        private Reason reason;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastSuppressed")
        private Date timeLastSuppressed;
        @JsonProperty(value="messageId")
        private String messageId;
        @JsonProperty(value="errorDetail")
        private String errorDetail;
        @JsonProperty(value="errorSource")
        private String errorSource;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.__explicitlySet__.add("emailAddress");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder reason(Reason reason) {
            this.reason = reason;
            this.__explicitlySet__.add("reason");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastSuppressed(Date timeLastSuppressed) {
            this.timeLastSuppressed = timeLastSuppressed;
            this.__explicitlySet__.add("timeLastSuppressed");
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            this.__explicitlySet__.add("messageId");
            return this;
        }

        public Builder errorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
            this.__explicitlySet__.add("errorDetail");
            return this;
        }

        public Builder errorSource(String errorSource) {
            this.errorSource = errorSource;
            this.__explicitlySet__.add("errorSource");
            return this;
        }

        public Suppression build() {
            Suppression model = new Suppression(this.compartmentId, this.emailAddress, this.id, this.reason, this.timeCreated, this.timeLastSuppressed, this.messageId, this.errorDetail, this.errorSource);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Suppression model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("emailAddress")) {
                this.emailAddress(model.getEmailAddress());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("reason")) {
                this.reason(model.getReason());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastSuppressed")) {
                this.timeLastSuppressed(model.getTimeLastSuppressed());
            }
            if (model.wasPropertyExplicitlySet("messageId")) {
                this.messageId(model.getMessageId());
            }
            if (model.wasPropertyExplicitlySet("errorDetail")) {
                this.errorDetail(model.getErrorDetail());
            }
            if (model.wasPropertyExplicitlySet("errorSource")) {
                this.errorSource(model.getErrorSource());
            }
            return this;
        }
    }
}

