/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dts.model.CreateTransferJobDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTransferJobRequest
extends BmcRequest<CreateTransferJobDetails> {
    private CreateTransferJobDetails createTransferJobDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public CreateTransferJobDetails getCreateTransferJobDetails() {
        return this.createTransferJobDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateTransferJobDetails getBody$() {
        return this.createTransferJobDetails;
    }

    public Builder toBuilder() {
        return new Builder().createTransferJobDetails(this.createTransferJobDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createTransferJobDetails=").append(String.valueOf((Object)this.createTransferJobDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTransferJobRequest)) {
            return false;
        }
        CreateTransferJobRequest other = (CreateTransferJobRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createTransferJobDetails, (Object)other.createTransferJobDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createTransferJobDetails == null ? 43 : this.createTransferJobDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTransferJobRequest, CreateTransferJobDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateTransferJobDetails createTransferJobDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder createTransferJobDetails(CreateTransferJobDetails createTransferJobDetails) {
            this.createTransferJobDetails = createTransferJobDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTransferJobRequest o) {
            this.createTransferJobDetails(o.getCreateTransferJobDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTransferJobRequest build() {
            CreateTransferJobRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTransferJobDetails body) {
            this.createTransferJobDetails(body);
            return this;
        }

        public CreateTransferJobRequest buildWithoutInvocationCallback() {
            CreateTransferJobRequest request = new CreateTransferJobRequest();
            request.createTransferJobDetails = this.createTransferJobDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

