/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dts.model.CreateTransferDeviceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateTransferDeviceRequest
extends BmcRequest<CreateTransferDeviceDetails> {
    private String id;
    private CreateTransferDeviceDetails createTransferDeviceDetails;
    private String opcRetryToken;

    public String getId() {
        return this.id;
    }

    public CreateTransferDeviceDetails getCreateTransferDeviceDetails() {
        return this.createTransferDeviceDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateTransferDeviceDetails getBody$() {
        return this.createTransferDeviceDetails;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).createTransferDeviceDetails(this.createTransferDeviceDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",createTransferDeviceDetails=").append(String.valueOf((Object)this.createTransferDeviceDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTransferDeviceRequest)) {
            return false;
        }
        CreateTransferDeviceRequest other = (CreateTransferDeviceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.createTransferDeviceDetails, (Object)other.createTransferDeviceDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.createTransferDeviceDetails == null ? 43 : this.createTransferDeviceDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateTransferDeviceRequest, CreateTransferDeviceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private CreateTransferDeviceDetails createTransferDeviceDetails = null;
        private String opcRetryToken = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createTransferDeviceDetails(CreateTransferDeviceDetails createTransferDeviceDetails) {
            this.createTransferDeviceDetails = createTransferDeviceDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateTransferDeviceRequest o) {
            this.id(o.getId());
            this.createTransferDeviceDetails(o.getCreateTransferDeviceDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateTransferDeviceRequest build() {
            CreateTransferDeviceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateTransferDeviceDetails body) {
            this.createTransferDeviceDetails(body);
            return this;
        }

        public CreateTransferDeviceRequest buildWithoutInvocationCallback() {
            CreateTransferDeviceRequest request = new CreateTransferDeviceRequest();
            request.id = this.id;
            request.createTransferDeviceDetails = this.createTransferDeviceDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

