/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dts.model.AttachDevicesDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class AttachDevicesToTransferPackageRequest
extends BmcRequest<AttachDevicesDetails> {
    private String id;
    private String transferPackageLabel;
    private AttachDevicesDetails attachDevicesDetails;
    private String opcRetryToken;

    public String getId() {
        return this.id;
    }

    public String getTransferPackageLabel() {
        return this.transferPackageLabel;
    }

    public AttachDevicesDetails getAttachDevicesDetails() {
        return this.attachDevicesDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public AttachDevicesDetails getBody$() {
        return this.attachDevicesDetails;
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).transferPackageLabel(this.transferPackageLabel).attachDevicesDetails(this.attachDevicesDetails).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",transferPackageLabel=").append(String.valueOf(this.transferPackageLabel));
        sb.append(",attachDevicesDetails=").append(String.valueOf((Object)this.attachDevicesDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttachDevicesToTransferPackageRequest)) {
            return false;
        }
        AttachDevicesToTransferPackageRequest other = (AttachDevicesToTransferPackageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.id, other.id) && Objects.equals(this.transferPackageLabel, other.transferPackageLabel) && Objects.equals((Object)this.attachDevicesDetails, (Object)other.attachDevicesDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.transferPackageLabel == null ? 43 : this.transferPackageLabel.hashCode());
        result = result * 59 + (this.attachDevicesDetails == null ? 43 : this.attachDevicesDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AttachDevicesToTransferPackageRequest, AttachDevicesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String id = null;
        private String transferPackageLabel = null;
        private AttachDevicesDetails attachDevicesDetails = null;
        private String opcRetryToken = null;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder transferPackageLabel(String transferPackageLabel) {
            this.transferPackageLabel = transferPackageLabel;
            return this;
        }

        public Builder attachDevicesDetails(AttachDevicesDetails attachDevicesDetails) {
            this.attachDevicesDetails = attachDevicesDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AttachDevicesToTransferPackageRequest o) {
            this.id(o.getId());
            this.transferPackageLabel(o.getTransferPackageLabel());
            this.attachDevicesDetails(o.getAttachDevicesDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AttachDevicesToTransferPackageRequest build() {
            AttachDevicesToTransferPackageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(AttachDevicesDetails body) {
            this.attachDevicesDetails(body);
            return this;
        }

        public AttachDevicesToTransferPackageRequest buildWithoutInvocationCallback() {
            AttachDevicesToTransferPackageRequest request = new AttachDevicesToTransferPackageRequest();
            request.id = this.id;
            request.transferPackageLabel = this.transferPackageLabel;
            request.attachDevicesDetails = this.attachDevicesDetails;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

