/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dts.model.ShippingAddress;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TransferAppliance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="transferJobId")
    private final String transferJobId;
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="creationTime")
    private final Date creationTime;
    @JsonProperty(value="customerReceivedTime")
    private final Date customerReceivedTime;
    @JsonProperty(value="customerReturnedTime")
    private final Date customerReturnedTime;
    @JsonProperty(value="nextBillingTime")
    private final Date nextBillingTime;
    @JsonProperty(value="deliverySecurityTieId")
    private final String deliverySecurityTieId;
    @JsonProperty(value="returnSecurityTieId")
    private final String returnSecurityTieId;
    @JsonProperty(value="applianceDeliveryTrackingNumber")
    private final String applianceDeliveryTrackingNumber;
    @JsonProperty(value="applianceReturnDeliveryTrackingNumber")
    private final String applianceReturnDeliveryTrackingNumber;
    @JsonProperty(value="applianceDeliveryVendor")
    private final String applianceDeliveryVendor;
    @JsonProperty(value="customerShippingAddress")
    private final ShippingAddress customerShippingAddress;
    @JsonProperty(value="uploadStatusLogUri")
    private final String uploadStatusLogUri;
    @JsonProperty(value="returnShippingLabelUri")
    private final String returnShippingLabelUri;
    @JsonProperty(value="expectedReturnDate")
    private final Date expectedReturnDate;
    @JsonProperty(value="pickupWindowStartTime")
    private final Date pickupWindowStartTime;
    @JsonProperty(value="pickupWindowEndTime")
    private final Date pickupWindowEndTime;
    @JsonProperty(value="minimumStorageCapacityInTerabytes")
    private final Integer minimumStorageCapacityInTerabytes;

    @Deprecated
    @ConstructorProperties(value={"label", "lifecycleState", "transferJobId", "serialNumber", "creationTime", "customerReceivedTime", "customerReturnedTime", "nextBillingTime", "deliverySecurityTieId", "returnSecurityTieId", "applianceDeliveryTrackingNumber", "applianceReturnDeliveryTrackingNumber", "applianceDeliveryVendor", "customerShippingAddress", "uploadStatusLogUri", "returnShippingLabelUri", "expectedReturnDate", "pickupWindowStartTime", "pickupWindowEndTime", "minimumStorageCapacityInTerabytes"})
    public TransferAppliance(String label, LifecycleState lifecycleState, String transferJobId, String serialNumber, Date creationTime, Date customerReceivedTime, Date customerReturnedTime, Date nextBillingTime, String deliverySecurityTieId, String returnSecurityTieId, String applianceDeliveryTrackingNumber, String applianceReturnDeliveryTrackingNumber, String applianceDeliveryVendor, ShippingAddress customerShippingAddress, String uploadStatusLogUri, String returnShippingLabelUri, Date expectedReturnDate, Date pickupWindowStartTime, Date pickupWindowEndTime, Integer minimumStorageCapacityInTerabytes) {
        this.label = label;
        this.lifecycleState = lifecycleState;
        this.transferJobId = transferJobId;
        this.serialNumber = serialNumber;
        this.creationTime = creationTime;
        this.customerReceivedTime = customerReceivedTime;
        this.customerReturnedTime = customerReturnedTime;
        this.nextBillingTime = nextBillingTime;
        this.deliverySecurityTieId = deliverySecurityTieId;
        this.returnSecurityTieId = returnSecurityTieId;
        this.applianceDeliveryTrackingNumber = applianceDeliveryTrackingNumber;
        this.applianceReturnDeliveryTrackingNumber = applianceReturnDeliveryTrackingNumber;
        this.applianceDeliveryVendor = applianceDeliveryVendor;
        this.customerShippingAddress = customerShippingAddress;
        this.uploadStatusLogUri = uploadStatusLogUri;
        this.returnShippingLabelUri = returnShippingLabelUri;
        this.expectedReturnDate = expectedReturnDate;
        this.pickupWindowStartTime = pickupWindowStartTime;
        this.pickupWindowEndTime = pickupWindowEndTime;
        this.minimumStorageCapacityInTerabytes = minimumStorageCapacityInTerabytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLabel() {
        return this.label;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getTransferJobId() {
        return this.transferJobId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getCustomerReceivedTime() {
        return this.customerReceivedTime;
    }

    public Date getCustomerReturnedTime() {
        return this.customerReturnedTime;
    }

    public Date getNextBillingTime() {
        return this.nextBillingTime;
    }

    public String getDeliverySecurityTieId() {
        return this.deliverySecurityTieId;
    }

    public String getReturnSecurityTieId() {
        return this.returnSecurityTieId;
    }

    public String getApplianceDeliveryTrackingNumber() {
        return this.applianceDeliveryTrackingNumber;
    }

    public String getApplianceReturnDeliveryTrackingNumber() {
        return this.applianceReturnDeliveryTrackingNumber;
    }

    public String getApplianceDeliveryVendor() {
        return this.applianceDeliveryVendor;
    }

    public ShippingAddress getCustomerShippingAddress() {
        return this.customerShippingAddress;
    }

    public String getUploadStatusLogUri() {
        return this.uploadStatusLogUri;
    }

    public String getReturnShippingLabelUri() {
        return this.returnShippingLabelUri;
    }

    public Date getExpectedReturnDate() {
        return this.expectedReturnDate;
    }

    public Date getPickupWindowStartTime() {
        return this.pickupWindowStartTime;
    }

    public Date getPickupWindowEndTime() {
        return this.pickupWindowEndTime;
    }

    public Integer getMinimumStorageCapacityInTerabytes() {
        return this.minimumStorageCapacityInTerabytes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TransferAppliance(");
        sb.append("super=").append(super.toString());
        sb.append("label=").append(String.valueOf(this.label));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", transferJobId=").append(String.valueOf(this.transferJobId));
        sb.append(", serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", creationTime=").append(String.valueOf(this.creationTime));
        sb.append(", customerReceivedTime=").append(String.valueOf(this.customerReceivedTime));
        sb.append(", customerReturnedTime=").append(String.valueOf(this.customerReturnedTime));
        sb.append(", nextBillingTime=").append(String.valueOf(this.nextBillingTime));
        sb.append(", deliverySecurityTieId=").append(String.valueOf(this.deliverySecurityTieId));
        sb.append(", returnSecurityTieId=").append(String.valueOf(this.returnSecurityTieId));
        sb.append(", applianceDeliveryTrackingNumber=").append(String.valueOf(this.applianceDeliveryTrackingNumber));
        sb.append(", applianceReturnDeliveryTrackingNumber=").append(String.valueOf(this.applianceReturnDeliveryTrackingNumber));
        sb.append(", applianceDeliveryVendor=").append(String.valueOf(this.applianceDeliveryVendor));
        sb.append(", customerShippingAddress=").append(String.valueOf((Object)this.customerShippingAddress));
        sb.append(", uploadStatusLogUri=").append(String.valueOf(this.uploadStatusLogUri));
        sb.append(", returnShippingLabelUri=").append(String.valueOf(this.returnShippingLabelUri));
        sb.append(", expectedReturnDate=").append(String.valueOf(this.expectedReturnDate));
        sb.append(", pickupWindowStartTime=").append(String.valueOf(this.pickupWindowStartTime));
        sb.append(", pickupWindowEndTime=").append(String.valueOf(this.pickupWindowEndTime));
        sb.append(", minimumStorageCapacityInTerabytes=").append(String.valueOf(this.minimumStorageCapacityInTerabytes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferAppliance)) {
            return false;
        }
        TransferAppliance other = (TransferAppliance)((Object)o);
        return Objects.equals(this.label, other.label) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.transferJobId, other.transferJobId) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.creationTime, other.creationTime) && Objects.equals(this.customerReceivedTime, other.customerReceivedTime) && Objects.equals(this.customerReturnedTime, other.customerReturnedTime) && Objects.equals(this.nextBillingTime, other.nextBillingTime) && Objects.equals(this.deliverySecurityTieId, other.deliverySecurityTieId) && Objects.equals(this.returnSecurityTieId, other.returnSecurityTieId) && Objects.equals(this.applianceDeliveryTrackingNumber, other.applianceDeliveryTrackingNumber) && Objects.equals(this.applianceReturnDeliveryTrackingNumber, other.applianceReturnDeliveryTrackingNumber) && Objects.equals(this.applianceDeliveryVendor, other.applianceDeliveryVendor) && Objects.equals((Object)this.customerShippingAddress, (Object)other.customerShippingAddress) && Objects.equals(this.uploadStatusLogUri, other.uploadStatusLogUri) && Objects.equals(this.returnShippingLabelUri, other.returnShippingLabelUri) && Objects.equals(this.expectedReturnDate, other.expectedReturnDate) && Objects.equals(this.pickupWindowStartTime, other.pickupWindowStartTime) && Objects.equals(this.pickupWindowEndTime, other.pickupWindowEndTime) && Objects.equals(this.minimumStorageCapacityInTerabytes, other.minimumStorageCapacityInTerabytes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.transferJobId == null ? 43 : this.transferJobId.hashCode());
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.creationTime == null ? 43 : this.creationTime.hashCode());
        result = result * 59 + (this.customerReceivedTime == null ? 43 : this.customerReceivedTime.hashCode());
        result = result * 59 + (this.customerReturnedTime == null ? 43 : this.customerReturnedTime.hashCode());
        result = result * 59 + (this.nextBillingTime == null ? 43 : this.nextBillingTime.hashCode());
        result = result * 59 + (this.deliverySecurityTieId == null ? 43 : this.deliverySecurityTieId.hashCode());
        result = result * 59 + (this.returnSecurityTieId == null ? 43 : this.returnSecurityTieId.hashCode());
        result = result * 59 + (this.applianceDeliveryTrackingNumber == null ? 43 : this.applianceDeliveryTrackingNumber.hashCode());
        result = result * 59 + (this.applianceReturnDeliveryTrackingNumber == null ? 43 : this.applianceReturnDeliveryTrackingNumber.hashCode());
        result = result * 59 + (this.applianceDeliveryVendor == null ? 43 : this.applianceDeliveryVendor.hashCode());
        result = result * 59 + (this.customerShippingAddress == null ? 43 : this.customerShippingAddress.hashCode());
        result = result * 59 + (this.uploadStatusLogUri == null ? 43 : this.uploadStatusLogUri.hashCode());
        result = result * 59 + (this.returnShippingLabelUri == null ? 43 : this.returnShippingLabelUri.hashCode());
        result = result * 59 + (this.expectedReturnDate == null ? 43 : this.expectedReturnDate.hashCode());
        result = result * 59 + (this.pickupWindowStartTime == null ? 43 : this.pickupWindowStartTime.hashCode());
        result = result * 59 + (this.pickupWindowEndTime == null ? 43 : this.pickupWindowEndTime.hashCode());
        result = result * 59 + (this.minimumStorageCapacityInTerabytes == null ? 43 : this.minimumStorageCapacityInTerabytes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Requested("REQUESTED"),
        OraclePreparing("ORACLE_PREPARING"),
        Shipping("SHIPPING"),
        Delivered("DELIVERED"),
        Preparing("PREPARING"),
        Finalized("FINALIZED"),
        ReturnLabelRequested("RETURN_LABEL_REQUESTED"),
        ReturnLabelGenerating("RETURN_LABEL_GENERATING"),
        ReturnLabelAvailable("RETURN_LABEL_AVAILABLE"),
        ReturnDelayed("RETURN_DELAYED"),
        ReturnShipped("RETURN_SHIPPED"),
        ReturnShippedCancelled("RETURN_SHIPPED_CANCELLED"),
        OracleReceived("ORACLE_RECEIVED"),
        OracleReceivedCancelled("ORACLE_RECEIVED_CANCELLED"),
        Processing("PROCESSING"),
        Complete("COMPLETE"),
        CustomerNeverReceived("CUSTOMER_NEVER_RECEIVED"),
        OracleNeverReceived("ORACLE_NEVER_RECEIVED"),
        CustomerLost("CUSTOMER_LOST"),
        Cancelled("CANCELLED"),
        Deleted("DELETED"),
        Rejected("REJECTED"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="transferJobId")
        private String transferJobId;
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="creationTime")
        private Date creationTime;
        @JsonProperty(value="customerReceivedTime")
        private Date customerReceivedTime;
        @JsonProperty(value="customerReturnedTime")
        private Date customerReturnedTime;
        @JsonProperty(value="nextBillingTime")
        private Date nextBillingTime;
        @JsonProperty(value="deliverySecurityTieId")
        private String deliverySecurityTieId;
        @JsonProperty(value="returnSecurityTieId")
        private String returnSecurityTieId;
        @JsonProperty(value="applianceDeliveryTrackingNumber")
        private String applianceDeliveryTrackingNumber;
        @JsonProperty(value="applianceReturnDeliveryTrackingNumber")
        private String applianceReturnDeliveryTrackingNumber;
        @JsonProperty(value="applianceDeliveryVendor")
        private String applianceDeliveryVendor;
        @JsonProperty(value="customerShippingAddress")
        private ShippingAddress customerShippingAddress;
        @JsonProperty(value="uploadStatusLogUri")
        private String uploadStatusLogUri;
        @JsonProperty(value="returnShippingLabelUri")
        private String returnShippingLabelUri;
        @JsonProperty(value="expectedReturnDate")
        private Date expectedReturnDate;
        @JsonProperty(value="pickupWindowStartTime")
        private Date pickupWindowStartTime;
        @JsonProperty(value="pickupWindowEndTime")
        private Date pickupWindowEndTime;
        @JsonProperty(value="minimumStorageCapacityInTerabytes")
        private Integer minimumStorageCapacityInTerabytes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder transferJobId(String transferJobId) {
            this.transferJobId = transferJobId;
            this.__explicitlySet__.add("transferJobId");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder creationTime(Date creationTime) {
            this.creationTime = creationTime;
            this.__explicitlySet__.add("creationTime");
            return this;
        }

        public Builder customerReceivedTime(Date customerReceivedTime) {
            this.customerReceivedTime = customerReceivedTime;
            this.__explicitlySet__.add("customerReceivedTime");
            return this;
        }

        public Builder customerReturnedTime(Date customerReturnedTime) {
            this.customerReturnedTime = customerReturnedTime;
            this.__explicitlySet__.add("customerReturnedTime");
            return this;
        }

        public Builder nextBillingTime(Date nextBillingTime) {
            this.nextBillingTime = nextBillingTime;
            this.__explicitlySet__.add("nextBillingTime");
            return this;
        }

        public Builder deliverySecurityTieId(String deliverySecurityTieId) {
            this.deliverySecurityTieId = deliverySecurityTieId;
            this.__explicitlySet__.add("deliverySecurityTieId");
            return this;
        }

        public Builder returnSecurityTieId(String returnSecurityTieId) {
            this.returnSecurityTieId = returnSecurityTieId;
            this.__explicitlySet__.add("returnSecurityTieId");
            return this;
        }

        public Builder applianceDeliveryTrackingNumber(String applianceDeliveryTrackingNumber) {
            this.applianceDeliveryTrackingNumber = applianceDeliveryTrackingNumber;
            this.__explicitlySet__.add("applianceDeliveryTrackingNumber");
            return this;
        }

        public Builder applianceReturnDeliveryTrackingNumber(String applianceReturnDeliveryTrackingNumber) {
            this.applianceReturnDeliveryTrackingNumber = applianceReturnDeliveryTrackingNumber;
            this.__explicitlySet__.add("applianceReturnDeliveryTrackingNumber");
            return this;
        }

        public Builder applianceDeliveryVendor(String applianceDeliveryVendor) {
            this.applianceDeliveryVendor = applianceDeliveryVendor;
            this.__explicitlySet__.add("applianceDeliveryVendor");
            return this;
        }

        public Builder customerShippingAddress(ShippingAddress customerShippingAddress) {
            this.customerShippingAddress = customerShippingAddress;
            this.__explicitlySet__.add("customerShippingAddress");
            return this;
        }

        public Builder uploadStatusLogUri(String uploadStatusLogUri) {
            this.uploadStatusLogUri = uploadStatusLogUri;
            this.__explicitlySet__.add("uploadStatusLogUri");
            return this;
        }

        public Builder returnShippingLabelUri(String returnShippingLabelUri) {
            this.returnShippingLabelUri = returnShippingLabelUri;
            this.__explicitlySet__.add("returnShippingLabelUri");
            return this;
        }

        public Builder expectedReturnDate(Date expectedReturnDate) {
            this.expectedReturnDate = expectedReturnDate;
            this.__explicitlySet__.add("expectedReturnDate");
            return this;
        }

        public Builder pickupWindowStartTime(Date pickupWindowStartTime) {
            this.pickupWindowStartTime = pickupWindowStartTime;
            this.__explicitlySet__.add("pickupWindowStartTime");
            return this;
        }

        public Builder pickupWindowEndTime(Date pickupWindowEndTime) {
            this.pickupWindowEndTime = pickupWindowEndTime;
            this.__explicitlySet__.add("pickupWindowEndTime");
            return this;
        }

        public Builder minimumStorageCapacityInTerabytes(Integer minimumStorageCapacityInTerabytes) {
            this.minimumStorageCapacityInTerabytes = minimumStorageCapacityInTerabytes;
            this.__explicitlySet__.add("minimumStorageCapacityInTerabytes");
            return this;
        }

        public TransferAppliance build() {
            TransferAppliance model = new TransferAppliance(this.label, this.lifecycleState, this.transferJobId, this.serialNumber, this.creationTime, this.customerReceivedTime, this.customerReturnedTime, this.nextBillingTime, this.deliverySecurityTieId, this.returnSecurityTieId, this.applianceDeliveryTrackingNumber, this.applianceReturnDeliveryTrackingNumber, this.applianceDeliveryVendor, this.customerShippingAddress, this.uploadStatusLogUri, this.returnShippingLabelUri, this.expectedReturnDate, this.pickupWindowStartTime, this.pickupWindowEndTime, this.minimumStorageCapacityInTerabytes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TransferAppliance model) {
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("transferJobId")) {
                this.transferJobId(model.getTransferJobId());
            }
            if (model.wasPropertyExplicitlySet("serialNumber")) {
                this.serialNumber(model.getSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("creationTime")) {
                this.creationTime(model.getCreationTime());
            }
            if (model.wasPropertyExplicitlySet("customerReceivedTime")) {
                this.customerReceivedTime(model.getCustomerReceivedTime());
            }
            if (model.wasPropertyExplicitlySet("customerReturnedTime")) {
                this.customerReturnedTime(model.getCustomerReturnedTime());
            }
            if (model.wasPropertyExplicitlySet("nextBillingTime")) {
                this.nextBillingTime(model.getNextBillingTime());
            }
            if (model.wasPropertyExplicitlySet("deliverySecurityTieId")) {
                this.deliverySecurityTieId(model.getDeliverySecurityTieId());
            }
            if (model.wasPropertyExplicitlySet("returnSecurityTieId")) {
                this.returnSecurityTieId(model.getReturnSecurityTieId());
            }
            if (model.wasPropertyExplicitlySet("applianceDeliveryTrackingNumber")) {
                this.applianceDeliveryTrackingNumber(model.getApplianceDeliveryTrackingNumber());
            }
            if (model.wasPropertyExplicitlySet("applianceReturnDeliveryTrackingNumber")) {
                this.applianceReturnDeliveryTrackingNumber(model.getApplianceReturnDeliveryTrackingNumber());
            }
            if (model.wasPropertyExplicitlySet("applianceDeliveryVendor")) {
                this.applianceDeliveryVendor(model.getApplianceDeliveryVendor());
            }
            if (model.wasPropertyExplicitlySet("customerShippingAddress")) {
                this.customerShippingAddress(model.getCustomerShippingAddress());
            }
            if (model.wasPropertyExplicitlySet("uploadStatusLogUri")) {
                this.uploadStatusLogUri(model.getUploadStatusLogUri());
            }
            if (model.wasPropertyExplicitlySet("returnShippingLabelUri")) {
                this.returnShippingLabelUri(model.getReturnShippingLabelUri());
            }
            if (model.wasPropertyExplicitlySet("expectedReturnDate")) {
                this.expectedReturnDate(model.getExpectedReturnDate());
            }
            if (model.wasPropertyExplicitlySet("pickupWindowStartTime")) {
                this.pickupWindowStartTime(model.getPickupWindowStartTime());
            }
            if (model.wasPropertyExplicitlySet("pickupWindowEndTime")) {
                this.pickupWindowEndTime(model.getPickupWindowEndTime());
            }
            if (model.wasPropertyExplicitlySet("minimumStorageCapacityInTerabytes")) {
                this.minimumStorageCapacityInTerabytes(model.getMinimumStorageCapacityInTerabytes());
            }
            return this;
        }
    }
}

