/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NewTransferDevice
extends ExplicitlySetBmcModel {
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="iscsiIQN")
    private final String iscsiIQN;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="encryptionPassphrase")
    private final String encryptionPassphrase;
    @JsonProperty(value="transferJobId")
    private final String transferJobId;
    @JsonProperty(value="creationTime")
    private final Date creationTime;

    @Deprecated
    @ConstructorProperties(value={"label", "serialNumber", "iscsiIQN", "lifecycleState", "encryptionPassphrase", "transferJobId", "creationTime"})
    public NewTransferDevice(String label, String serialNumber, String iscsiIQN, LifecycleState lifecycleState, String encryptionPassphrase, String transferJobId, Date creationTime) {
        this.label = label;
        this.serialNumber = serialNumber;
        this.iscsiIQN = iscsiIQN;
        this.lifecycleState = lifecycleState;
        this.encryptionPassphrase = encryptionPassphrase;
        this.transferJobId = transferJobId;
        this.creationTime = creationTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLabel() {
        return this.label;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getIscsiIQN() {
        return this.iscsiIQN;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getEncryptionPassphrase() {
        return this.encryptionPassphrase;
    }

    public String getTransferJobId() {
        return this.transferJobId;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NewTransferDevice(");
        sb.append("super=").append(super.toString());
        sb.append("label=").append(String.valueOf(this.label));
        sb.append(", serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", iscsiIQN=").append(String.valueOf(this.iscsiIQN));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", encryptionPassphrase=").append(String.valueOf(this.encryptionPassphrase));
        sb.append(", transferJobId=").append(String.valueOf(this.transferJobId));
        sb.append(", creationTime=").append(String.valueOf(this.creationTime));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NewTransferDevice)) {
            return false;
        }
        NewTransferDevice other = (NewTransferDevice)((Object)o);
        return Objects.equals(this.label, other.label) && Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.iscsiIQN, other.iscsiIQN) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.encryptionPassphrase, other.encryptionPassphrase) && Objects.equals(this.transferJobId, other.transferJobId) && Objects.equals(this.creationTime, other.creationTime) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.iscsiIQN == null ? 43 : this.iscsiIQN.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.encryptionPassphrase == null ? 43 : this.encryptionPassphrase.hashCode());
        result = result * 59 + (this.transferJobId == null ? 43 : this.transferJobId.hashCode());
        result = result * 59 + (this.creationTime == null ? 43 : this.creationTime.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Preparing("PREPARING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="iscsiIQN")
        private String iscsiIQN;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="encryptionPassphrase")
        private String encryptionPassphrase;
        @JsonProperty(value="transferJobId")
        private String transferJobId;
        @JsonProperty(value="creationTime")
        private Date creationTime;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder iscsiIQN(String iscsiIQN) {
            this.iscsiIQN = iscsiIQN;
            this.__explicitlySet__.add("iscsiIQN");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder encryptionPassphrase(String encryptionPassphrase) {
            this.encryptionPassphrase = encryptionPassphrase;
            this.__explicitlySet__.add("encryptionPassphrase");
            return this;
        }

        public Builder transferJobId(String transferJobId) {
            this.transferJobId = transferJobId;
            this.__explicitlySet__.add("transferJobId");
            return this;
        }

        public Builder creationTime(Date creationTime) {
            this.creationTime = creationTime;
            this.__explicitlySet__.add("creationTime");
            return this;
        }

        public NewTransferDevice build() {
            NewTransferDevice model = new NewTransferDevice(this.label, this.serialNumber, this.iscsiIQN, this.lifecycleState, this.encryptionPassphrase, this.transferJobId, this.creationTime);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NewTransferDevice model) {
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("serialNumber")) {
                this.serialNumber(model.getSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("iscsiIQN")) {
                this.iscsiIQN(model.getIscsiIQN());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("encryptionPassphrase")) {
                this.encryptionPassphrase(model.getEncryptionPassphrase());
            }
            if (model.wasPropertyExplicitlySet("transferJobId")) {
                this.transferJobId(model.getTransferJobId());
            }
            if (model.wasPropertyExplicitlySet("creationTime")) {
                this.creationTime(model.getCreationTime());
            }
            return this;
        }
    }
}

