/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.oracle.bmc.dts.TransferJob;
import com.oracle.bmc.dts.model.TransferJobSummary;
import com.oracle.bmc.dts.requests.ListTransferJobsRequest;
import com.oracle.bmc.dts.responses.ListTransferJobsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class TransferJobPaginators {
    private final TransferJob client;

    public TransferJobPaginators(TransferJob client) {
        this.client = client;
    }

    public Iterable<ListTransferJobsResponse> listTransferJobsResponseIterator(final ListTransferJobsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListTransferJobsRequest.Builder>(){

            @Override
            public ListTransferJobsRequest.Builder get() {
                return ListTransferJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTransferJobsResponse, String>(){

            @Override
            public String apply(ListTransferJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTransferJobsRequest.Builder>, ListTransferJobsRequest>(){

            @Override
            public ListTransferJobsRequest apply(RequestBuilderAndToken<ListTransferJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTransferJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTransferJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTransferJobsRequest, ListTransferJobsResponse>(){

            @Override
            public ListTransferJobsResponse apply(ListTransferJobsRequest request) {
                return TransferJobPaginators.this.client.listTransferJobs(request);
            }
        });
    }

    public Iterable<TransferJobSummary> listTransferJobsRecordIterator(final ListTransferJobsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListTransferJobsRequest.Builder>(){

            @Override
            public ListTransferJobsRequest.Builder get() {
                return ListTransferJobsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListTransferJobsResponse, String>(){

            @Override
            public String apply(ListTransferJobsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListTransferJobsRequest.Builder>, ListTransferJobsRequest>(){

            @Override
            public ListTransferJobsRequest apply(RequestBuilderAndToken<ListTransferJobsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListTransferJobsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListTransferJobsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListTransferJobsRequest, ListTransferJobsResponse>(){

            @Override
            public ListTransferJobsResponse apply(ListTransferJobsRequest request) {
                return TransferJobPaginators.this.client.listTransferJobs(request);
            }
        }, (Function)new Function<ListTransferJobsResponse, List<TransferJobSummary>>(){

            @Override
            public List<TransferJobSummary> apply(ListTransferJobsResponse response) {
                return response.getItems();
            }
        });
    }
}

