/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.responses;

import com.oracle.bmc.dns.model.Zone;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UpdateZoneResponse
extends BmcResponse {
    private String eTag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private Zone zone;

    public String getETag() {
        return this.eTag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public Zone getZone() {
        return this.zone;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "eTag", "opcRequestId", "opcWorkRequestId", "zone"})
    private UpdateZoneResponse(int __httpStatusCode__, Map<String, List<String>> headers, String eTag, String opcRequestId, String opcWorkRequestId, Zone zone) {
        super(__httpStatusCode__, headers);
        this.eTag = eTag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.zone = zone;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",eTag=").append(String.valueOf(this.eTag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",zone=").append(String.valueOf((Object)this.zone));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateZoneResponse)) {
            return false;
        }
        UpdateZoneResponse other = (UpdateZoneResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.eTag, other.eTag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals((Object)this.zone, (Object)other.zone);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.eTag == null ? 43 : this.eTag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.zone == null ? 43 : this.zone.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<UpdateZoneResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String eTag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private Zone zone;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public Builder copy(UpdateZoneResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.eTag(o.getETag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.zone(o.getZone());
            return this;
        }

        public UpdateZoneResponse build() {
            return new UpdateZoneResponse(this.__httpStatusCode__, this.headers, this.eTag, this.opcRequestId, this.opcWorkRequestId, this.zone);
        }
    }
}

