/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dns.model.ChangeResolverCompartmentDetails;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeResolverCompartmentRequest
extends BmcRequest<ChangeResolverCompartmentDetails> {
    private String resolverId;
    private ChangeResolverCompartmentDetails changeResolverCompartmentDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;
    private Scope scope;

    public String getResolverId() {
        return this.resolverId;
    }

    public ChangeResolverCompartmentDetails getChangeResolverCompartmentDetails() {
        return this.changeResolverCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    @InternalSdk
    public ChangeResolverCompartmentDetails getBody$() {
        return this.changeResolverCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().resolverId(this.resolverId).changeResolverCompartmentDetails(this.changeResolverCompartmentDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).scope(this.scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",resolverId=").append(String.valueOf(this.resolverId));
        sb.append(",changeResolverCompartmentDetails=").append(String.valueOf((Object)this.changeResolverCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",scope=").append(String.valueOf((Object)this.scope));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeResolverCompartmentRequest)) {
            return false;
        }
        ChangeResolverCompartmentRequest other = (ChangeResolverCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.resolverId, other.resolverId) && Objects.equals((Object)this.changeResolverCompartmentDetails, (Object)other.changeResolverCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.scope, (Object)other.scope);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resolverId == null ? 43 : this.resolverId.hashCode());
        result = result * 59 + (this.changeResolverCompartmentDetails == null ? 43 : this.changeResolverCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeResolverCompartmentRequest, ChangeResolverCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String resolverId = null;
        private ChangeResolverCompartmentDetails changeResolverCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private Scope scope = null;

        public Builder resolverId(String resolverId) {
            this.resolverId = resolverId;
            return this;
        }

        public Builder changeResolverCompartmentDetails(ChangeResolverCompartmentDetails changeResolverCompartmentDetails) {
            this.changeResolverCompartmentDetails = changeResolverCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeResolverCompartmentRequest o) {
            this.resolverId(o.getResolverId());
            this.changeResolverCompartmentDetails(o.getChangeResolverCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeResolverCompartmentRequest build() {
            ChangeResolverCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeResolverCompartmentDetails body) {
            this.changeResolverCompartmentDetails(body);
            return this;
        }

        public ChangeResolverCompartmentRequest buildWithoutInvocationCallback() {
            ChangeResolverCompartmentRequest request = new ChangeResolverCompartmentRequest();
            request.resolverId = this.resolverId;
            request.changeResolverCompartmentDetails = this.changeResolverCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.scope = this.scope;
            return request;
        }
    }
}

