/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Record
extends ExplicitlySetBmcModel {
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="recordHash")
    private final String recordHash;
    @JsonProperty(value="isProtected")
    private final Boolean isProtected;
    @JsonProperty(value="rdata")
    private final String rdata;
    @JsonProperty(value="rrsetVersion")
    private final String rrsetVersion;
    @JsonProperty(value="rtype")
    private final String rtype;
    @JsonProperty(value="ttl")
    private final Integer ttl;

    @Deprecated
    @ConstructorProperties(value={"domain", "recordHash", "isProtected", "rdata", "rrsetVersion", "rtype", "ttl"})
    public Record(String domain, String recordHash, Boolean isProtected, String rdata, String rrsetVersion, String rtype, Integer ttl) {
        this.domain = domain;
        this.recordHash = recordHash;
        this.isProtected = isProtected;
        this.rdata = rdata;
        this.rrsetVersion = rrsetVersion;
        this.rtype = rtype;
        this.ttl = ttl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRecordHash() {
        return this.recordHash;
    }

    public Boolean getIsProtected() {
        return this.isProtected;
    }

    public String getRdata() {
        return this.rdata;
    }

    public String getRrsetVersion() {
        return this.rrsetVersion;
    }

    public String getRtype() {
        return this.rtype;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Record(");
        sb.append("super=").append(super.toString());
        sb.append("domain=").append(String.valueOf(this.domain));
        sb.append(", recordHash=").append(String.valueOf(this.recordHash));
        sb.append(", isProtected=").append(String.valueOf(this.isProtected));
        sb.append(", rdata=").append(String.valueOf(this.rdata));
        sb.append(", rrsetVersion=").append(String.valueOf(this.rrsetVersion));
        sb.append(", rtype=").append(String.valueOf(this.rtype));
        sb.append(", ttl=").append(String.valueOf(this.ttl));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record other = (Record)((Object)o);
        return Objects.equals(this.domain, other.domain) && Objects.equals(this.recordHash, other.recordHash) && Objects.equals(this.isProtected, other.isProtected) && Objects.equals(this.rdata, other.rdata) && Objects.equals(this.rrsetVersion, other.rrsetVersion) && Objects.equals(this.rtype, other.rtype) && Objects.equals(this.ttl, other.ttl) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.recordHash == null ? 43 : this.recordHash.hashCode());
        result = result * 59 + (this.isProtected == null ? 43 : this.isProtected.hashCode());
        result = result * 59 + (this.rdata == null ? 43 : this.rdata.hashCode());
        result = result * 59 + (this.rrsetVersion == null ? 43 : this.rrsetVersion.hashCode());
        result = result * 59 + (this.rtype == null ? 43 : this.rtype.hashCode());
        result = result * 59 + (this.ttl == null ? 43 : this.ttl.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="recordHash")
        private String recordHash;
        @JsonProperty(value="isProtected")
        private Boolean isProtected;
        @JsonProperty(value="rdata")
        private String rdata;
        @JsonProperty(value="rrsetVersion")
        private String rrsetVersion;
        @JsonProperty(value="rtype")
        private String rtype;
        @JsonProperty(value="ttl")
        private Integer ttl;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder recordHash(String recordHash) {
            this.recordHash = recordHash;
            this.__explicitlySet__.add("recordHash");
            return this;
        }

        public Builder isProtected(Boolean isProtected) {
            this.isProtected = isProtected;
            this.__explicitlySet__.add("isProtected");
            return this;
        }

        public Builder rdata(String rdata) {
            this.rdata = rdata;
            this.__explicitlySet__.add("rdata");
            return this;
        }

        public Builder rrsetVersion(String rrsetVersion) {
            this.rrsetVersion = rrsetVersion;
            this.__explicitlySet__.add("rrsetVersion");
            return this;
        }

        public Builder rtype(String rtype) {
            this.rtype = rtype;
            this.__explicitlySet__.add("rtype");
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            this.__explicitlySet__.add("ttl");
            return this;
        }

        public Record build() {
            Record model = new Record(this.domain, this.recordHash, this.isProtected, this.rdata, this.rrsetVersion, this.rtype, this.ttl);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Record model) {
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("recordHash")) {
                this.recordHash(model.getRecordHash());
            }
            if (model.wasPropertyExplicitlySet("isProtected")) {
                this.isProtected(model.getIsProtected());
            }
            if (model.wasPropertyExplicitlySet("rdata")) {
                this.rdata(model.getRdata());
            }
            if (model.wasPropertyExplicitlySet("rrsetVersion")) {
                this.rrsetVersion(model.getRrsetVersion());
            }
            if (model.wasPropertyExplicitlySet("rtype")) {
                this.rtype(model.getRtype());
            }
            if (model.wasPropertyExplicitlySet("ttl")) {
                this.ttl(model.getTtl());
            }
            return this;
        }
    }
}

