/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.disasterrecovery.model.DrPlanLifecycleState;
import com.oracle.bmc.disasterrecovery.model.DrPlanType;
import com.oracle.bmc.disasterrecovery.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDrPlansRequest
extends BmcRequest<Void> {
    private String drProtectionGroupId;
    private DrPlanLifecycleState lifecycleState;
    private String drPlanId;
    private DrPlanType drPlanType;
    private String displayName;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getDrProtectionGroupId() {
        return this.drProtectionGroupId;
    }

    public DrPlanLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDrPlanId() {
        return this.drPlanId;
    }

    public DrPlanType getDrPlanType() {
        return this.drPlanType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().drProtectionGroupId(this.drProtectionGroupId).lifecycleState(this.lifecycleState).drPlanId(this.drPlanId).drPlanType(this.drPlanType).displayName(this.displayName).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drProtectionGroupId=").append(String.valueOf(this.drProtectionGroupId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",drPlanId=").append(String.valueOf(this.drPlanId));
        sb.append(",drPlanType=").append(String.valueOf((Object)this.drPlanType));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDrPlansRequest)) {
            return false;
        }
        ListDrPlansRequest other = (ListDrPlansRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drProtectionGroupId, other.drProtectionGroupId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.drPlanId, other.drPlanId) && Objects.equals((Object)this.drPlanType, (Object)other.drPlanType) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drProtectionGroupId == null ? 43 : this.drProtectionGroupId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.drPlanId == null ? 43 : this.drPlanId.hashCode());
        result = result * 59 + (this.drPlanType == null ? 43 : this.drPlanType.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDrPlansRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drProtectionGroupId = null;
        private DrPlanLifecycleState lifecycleState = null;
        private String drPlanId = null;
        private DrPlanType drPlanType = null;
        private String displayName = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder drProtectionGroupId(String drProtectionGroupId) {
            this.drProtectionGroupId = drProtectionGroupId;
            return this;
        }

        public Builder lifecycleState(DrPlanLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder drPlanId(String drPlanId) {
            this.drPlanId = drPlanId;
            return this;
        }

        public Builder drPlanType(DrPlanType drPlanType) {
            this.drPlanType = drPlanType;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDrPlansRequest o) {
            this.drProtectionGroupId(o.getDrProtectionGroupId());
            this.lifecycleState(o.getLifecycleState());
            this.drPlanId(o.getDrPlanId());
            this.drPlanType(o.getDrPlanType());
            this.displayName(o.getDisplayName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDrPlansRequest build() {
            ListDrPlansRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDrPlansRequest buildWithoutInvocationCallback() {
            ListDrPlansRequest request = new ListDrPlansRequest();
            request.drProtectionGroupId = this.drProtectionGroupId;
            request.lifecycleState = this.lifecycleState;
            request.drPlanId = this.drPlanId;
            request.drPlanType = this.drPlanType;
            request.displayName = this.displayName;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

