/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDrPlanExecutionRequest
extends BmcRequest<Void> {
    private String drPlanExecutionId;
    private String opcRequestId;

    public String getDrPlanExecutionId() {
        return this.drPlanExecutionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().drPlanExecutionId(this.drPlanExecutionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drPlanExecutionId=").append(String.valueOf(this.drPlanExecutionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDrPlanExecutionRequest)) {
            return false;
        }
        GetDrPlanExecutionRequest other = (GetDrPlanExecutionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drPlanExecutionId, other.drPlanExecutionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drPlanExecutionId == null ? 43 : this.drPlanExecutionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDrPlanExecutionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drPlanExecutionId = null;
        private String opcRequestId = null;

        public Builder drPlanExecutionId(String drPlanExecutionId) {
            this.drPlanExecutionId = drPlanExecutionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDrPlanExecutionRequest o) {
            this.drPlanExecutionId(o.getDrPlanExecutionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDrPlanExecutionRequest build() {
            GetDrPlanExecutionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDrPlanExecutionRequest buildWithoutInvocationCallback() {
            GetDrPlanExecutionRequest request = new GetDrPlanExecutionRequest();
            request.drPlanExecutionId = this.drPlanExecutionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

