/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.disasterrecovery.model.DrPlanStepExecutionStatus;
import com.oracle.bmc.disasterrecovery.model.DrPlanStepType;
import com.oracle.bmc.disasterrecovery.model.ObjectStorageLogLocation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DrPlanStepExecution
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stepId")
    private final String stepId;
    @JsonProperty(value="type")
    private final DrPlanStepType type;
    @JsonProperty(value="groupId")
    private final String groupId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="logLocation")
    private final ObjectStorageLogLocation logLocation;
    @JsonProperty(value="status")
    private final DrPlanStepExecutionStatus status;
    @JsonProperty(value="statusDetails")
    private final String statusDetails;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="executionDurationInSec")
    private final Integer executionDurationInSec;

    @Deprecated
    @ConstructorProperties(value={"stepId", "type", "groupId", "displayName", "logLocation", "status", "statusDetails", "timeStarted", "timeEnded", "executionDurationInSec"})
    public DrPlanStepExecution(String stepId, DrPlanStepType type, String groupId, String displayName, ObjectStorageLogLocation logLocation, DrPlanStepExecutionStatus status, String statusDetails, Date timeStarted, Date timeEnded, Integer executionDurationInSec) {
        this.stepId = stepId;
        this.type = type;
        this.groupId = groupId;
        this.displayName = displayName;
        this.logLocation = logLocation;
        this.status = status;
        this.statusDetails = statusDetails;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.executionDurationInSec = executionDurationInSec;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStepId() {
        return this.stepId;
    }

    public DrPlanStepType getType() {
        return this.type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ObjectStorageLogLocation getLogLocation() {
        return this.logLocation;
    }

    public DrPlanStepExecutionStatus getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public Integer getExecutionDurationInSec() {
        return this.executionDurationInSec;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DrPlanStepExecution(");
        sb.append("super=").append(super.toString());
        sb.append("stepId=").append(String.valueOf(this.stepId));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", groupId=").append(String.valueOf(this.groupId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", logLocation=").append(String.valueOf((Object)this.logLocation));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", statusDetails=").append(String.valueOf(this.statusDetails));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", executionDurationInSec=").append(String.valueOf(this.executionDurationInSec));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrPlanStepExecution)) {
            return false;
        }
        DrPlanStepExecution other = (DrPlanStepExecution)((Object)o);
        return Objects.equals(this.stepId, other.stepId) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.logLocation, (Object)other.logLocation) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.statusDetails, other.statusDetails) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.executionDurationInSec, other.executionDurationInSec) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stepId == null ? 43 : this.stepId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.groupId == null ? 43 : this.groupId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.logLocation == null ? 43 : this.logLocation.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.statusDetails == null ? 43 : this.statusDetails.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.executionDurationInSec == null ? 43 : this.executionDurationInSec.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stepId")
        private String stepId;
        @JsonProperty(value="type")
        private DrPlanStepType type;
        @JsonProperty(value="groupId")
        private String groupId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="logLocation")
        private ObjectStorageLogLocation logLocation;
        @JsonProperty(value="status")
        private DrPlanStepExecutionStatus status;
        @JsonProperty(value="statusDetails")
        private String statusDetails;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="executionDurationInSec")
        private Integer executionDurationInSec;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stepId(String stepId) {
            this.stepId = stepId;
            this.__explicitlySet__.add("stepId");
            return this;
        }

        public Builder type(DrPlanStepType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            this.__explicitlySet__.add("groupId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder logLocation(ObjectStorageLogLocation logLocation) {
            this.logLocation = logLocation;
            this.__explicitlySet__.add("logLocation");
            return this;
        }

        public Builder status(DrPlanStepExecutionStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            this.__explicitlySet__.add("statusDetails");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder executionDurationInSec(Integer executionDurationInSec) {
            this.executionDurationInSec = executionDurationInSec;
            this.__explicitlySet__.add("executionDurationInSec");
            return this;
        }

        public DrPlanStepExecution build() {
            DrPlanStepExecution model = new DrPlanStepExecution(this.stepId, this.type, this.groupId, this.displayName, this.logLocation, this.status, this.statusDetails, this.timeStarted, this.timeEnded, this.executionDurationInSec);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DrPlanStepExecution model) {
            if (model.wasPropertyExplicitlySet("stepId")) {
                this.stepId(model.getStepId());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("groupId")) {
                this.groupId(model.getGroupId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("logLocation")) {
                this.logLocation(model.getLogLocation());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("statusDetails")) {
                this.statusDetails(model.getStatusDetails());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("executionDurationInSec")) {
                this.executionDurationInSec(model.getExecutionDurationInSec());
            }
            return this;
        }
    }
}

