/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.disasterrecovery.model.DrPlanGroupExecutionStatus;
import com.oracle.bmc.disasterrecovery.model.DrPlanGroupType;
import com.oracle.bmc.disasterrecovery.model.DrPlanStepExecution;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DrPlanGroupExecution
extends ExplicitlySetBmcModel {
    @JsonProperty(value="groupId")
    private final String groupId;
    @JsonProperty(value="type")
    private final DrPlanGroupType type;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="status")
    private final DrPlanGroupExecutionStatus status;
    @JsonProperty(value="statusDetails")
    private final String statusDetails;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;
    @JsonProperty(value="executionDurationInSec")
    private final Integer executionDurationInSec;
    @JsonProperty(value="stepExecutions")
    private final List<DrPlanStepExecution> stepExecutions;

    @Deprecated
    @ConstructorProperties(value={"groupId", "type", "displayName", "status", "statusDetails", "timeStarted", "timeEnded", "executionDurationInSec", "stepExecutions"})
    public DrPlanGroupExecution(String groupId, DrPlanGroupType type, String displayName, DrPlanGroupExecutionStatus status, String statusDetails, Date timeStarted, Date timeEnded, Integer executionDurationInSec, List<DrPlanStepExecution> stepExecutions) {
        this.groupId = groupId;
        this.type = type;
        this.displayName = displayName;
        this.status = status;
        this.statusDetails = statusDetails;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
        this.executionDurationInSec = executionDurationInSec;
        this.stepExecutions = stepExecutions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public DrPlanGroupType getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DrPlanGroupExecutionStatus getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public Integer getExecutionDurationInSec() {
        return this.executionDurationInSec;
    }

    public List<DrPlanStepExecution> getStepExecutions() {
        return this.stepExecutions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DrPlanGroupExecution(");
        sb.append("super=").append(super.toString());
        sb.append("groupId=").append(String.valueOf(this.groupId));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", statusDetails=").append(String.valueOf(this.statusDetails));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(", executionDurationInSec=").append(String.valueOf(this.executionDurationInSec));
        sb.append(", stepExecutions=").append(String.valueOf(this.stepExecutions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrPlanGroupExecution)) {
            return false;
        }
        DrPlanGroupExecution other = (DrPlanGroupExecution)((Object)o);
        return Objects.equals(this.groupId, other.groupId) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.statusDetails, other.statusDetails) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.executionDurationInSec, other.executionDurationInSec) && Objects.equals(this.stepExecutions, other.stepExecutions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.groupId == null ? 43 : this.groupId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.statusDetails == null ? 43 : this.statusDetails.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.executionDurationInSec == null ? 43 : this.executionDurationInSec.hashCode());
        result = result * 59 + (this.stepExecutions == null ? 43 : this.stepExecutions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="groupId")
        private String groupId;
        @JsonProperty(value="type")
        private DrPlanGroupType type;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="status")
        private DrPlanGroupExecutionStatus status;
        @JsonProperty(value="statusDetails")
        private String statusDetails;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonProperty(value="executionDurationInSec")
        private Integer executionDurationInSec;
        @JsonProperty(value="stepExecutions")
        private List<DrPlanStepExecution> stepExecutions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            this.__explicitlySet__.add("groupId");
            return this;
        }

        public Builder type(DrPlanGroupType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder status(DrPlanGroupExecutionStatus status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            this.__explicitlySet__.add("statusDetails");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public Builder executionDurationInSec(Integer executionDurationInSec) {
            this.executionDurationInSec = executionDurationInSec;
            this.__explicitlySet__.add("executionDurationInSec");
            return this;
        }

        public Builder stepExecutions(List<DrPlanStepExecution> stepExecutions) {
            this.stepExecutions = stepExecutions;
            this.__explicitlySet__.add("stepExecutions");
            return this;
        }

        public DrPlanGroupExecution build() {
            DrPlanGroupExecution model = new DrPlanGroupExecution(this.groupId, this.type, this.displayName, this.status, this.statusDetails, this.timeStarted, this.timeEnded, this.executionDurationInSec, this.stepExecutions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DrPlanGroupExecution model) {
            if (model.wasPropertyExplicitlySet("groupId")) {
                this.groupId(model.getGroupId());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("statusDetails")) {
                this.statusDetails(model.getStatusDetails());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            if (model.wasPropertyExplicitlySet("executionDurationInSec")) {
                this.executionDurationInSec(model.getExecutionDurationInSec());
            }
            if (model.wasPropertyExplicitlySet("stepExecutions")) {
                this.stepExecutions(model.getStepExecutions());
            }
            return this;
        }
    }
}

