/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.disasterrecovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ComputeInstanceVnicMapping
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sourceVnicId")
    private final String sourceVnicId;
    @JsonProperty(value="destinationSubnetId")
    private final String destinationSubnetId;
    @JsonProperty(value="destinationNsgIdList")
    private final List<String> destinationNsgIdList;

    @Deprecated
    @ConstructorProperties(value={"sourceVnicId", "destinationSubnetId", "destinationNsgIdList"})
    public ComputeInstanceVnicMapping(String sourceVnicId, String destinationSubnetId, List<String> destinationNsgIdList) {
        this.sourceVnicId = sourceVnicId;
        this.destinationSubnetId = destinationSubnetId;
        this.destinationNsgIdList = destinationNsgIdList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSourceVnicId() {
        return this.sourceVnicId;
    }

    public String getDestinationSubnetId() {
        return this.destinationSubnetId;
    }

    public List<String> getDestinationNsgIdList() {
        return this.destinationNsgIdList;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ComputeInstanceVnicMapping(");
        sb.append("super=").append(super.toString());
        sb.append("sourceVnicId=").append(String.valueOf(this.sourceVnicId));
        sb.append(", destinationSubnetId=").append(String.valueOf(this.destinationSubnetId));
        sb.append(", destinationNsgIdList=").append(String.valueOf(this.destinationNsgIdList));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComputeInstanceVnicMapping)) {
            return false;
        }
        ComputeInstanceVnicMapping other = (ComputeInstanceVnicMapping)((Object)o);
        return Objects.equals(this.sourceVnicId, other.sourceVnicId) && Objects.equals(this.destinationSubnetId, other.destinationSubnetId) && Objects.equals(this.destinationNsgIdList, other.destinationNsgIdList) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sourceVnicId == null ? 43 : this.sourceVnicId.hashCode());
        result = result * 59 + (this.destinationSubnetId == null ? 43 : this.destinationSubnetId.hashCode());
        result = result * 59 + (this.destinationNsgIdList == null ? 43 : this.destinationNsgIdList.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourceVnicId")
        private String sourceVnicId;
        @JsonProperty(value="destinationSubnetId")
        private String destinationSubnetId;
        @JsonProperty(value="destinationNsgIdList")
        private List<String> destinationNsgIdList;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourceVnicId(String sourceVnicId) {
            this.sourceVnicId = sourceVnicId;
            this.__explicitlySet__.add("sourceVnicId");
            return this;
        }

        public Builder destinationSubnetId(String destinationSubnetId) {
            this.destinationSubnetId = destinationSubnetId;
            this.__explicitlySet__.add("destinationSubnetId");
            return this;
        }

        public Builder destinationNsgIdList(List<String> destinationNsgIdList) {
            this.destinationNsgIdList = destinationNsgIdList;
            this.__explicitlySet__.add("destinationNsgIdList");
            return this;
        }

        public ComputeInstanceVnicMapping build() {
            ComputeInstanceVnicMapping model = new ComputeInstanceVnicMapping(this.sourceVnicId, this.destinationSubnetId, this.destinationNsgIdList);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ComputeInstanceVnicMapping model) {
            if (model.wasPropertyExplicitlySet("sourceVnicId")) {
                this.sourceVnicId(model.getSourceVnicId());
            }
            if (model.wasPropertyExplicitlySet("destinationSubnetId")) {
                this.destinationSubnetId(model.getDestinationSubnetId());
            }
            if (model.wasPropertyExplicitlySet("destinationNsgIdList")) {
                this.destinationNsgIdList(model.getDestinationNsgIdList());
            }
            return this;
        }
    }
}

