/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.JobInfrastructureConfigurationDetails;
import com.oracle.bmc.datascience.model.JobShapeConfigDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="jobInfrastructureType")
@JsonFilter(value="explicitlySetFilter")
public final class StandaloneJobInfrastructureConfigurationDetails
extends JobInfrastructureConfigurationDetails {
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="blockStorageSizeInGBs")
    private final Integer blockStorageSizeInGBs;
    @JsonProperty(value="jobShapeConfigDetails")
    private final JobShapeConfigDetails jobShapeConfigDetails;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StandaloneJobInfrastructureConfigurationDetails(String shapeName, String subnetId, Integer blockStorageSizeInGBs, JobShapeConfigDetails jobShapeConfigDetails) {
        this.shapeName = shapeName;
        this.subnetId = subnetId;
        this.blockStorageSizeInGBs = blockStorageSizeInGBs;
        this.jobShapeConfigDetails = jobShapeConfigDetails;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public Integer getBlockStorageSizeInGBs() {
        return this.blockStorageSizeInGBs;
    }

    public JobShapeConfigDetails getJobShapeConfigDetails() {
        return this.jobShapeConfigDetails;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StandaloneJobInfrastructureConfigurationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", blockStorageSizeInGBs=").append(String.valueOf(this.blockStorageSizeInGBs));
        sb.append(", jobShapeConfigDetails=").append(String.valueOf((Object)this.jobShapeConfigDetails));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandaloneJobInfrastructureConfigurationDetails)) {
            return false;
        }
        StandaloneJobInfrastructureConfigurationDetails other = (StandaloneJobInfrastructureConfigurationDetails)((Object)o);
        return Objects.equals(this.shapeName, other.shapeName) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.blockStorageSizeInGBs, other.blockStorageSizeInGBs) && Objects.equals((Object)this.jobShapeConfigDetails, (Object)other.jobShapeConfigDetails) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.blockStorageSizeInGBs == null ? 43 : this.blockStorageSizeInGBs.hashCode());
        result = result * 59 + (this.jobShapeConfigDetails == null ? 43 : this.jobShapeConfigDetails.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="blockStorageSizeInGBs")
        private Integer blockStorageSizeInGBs;
        @JsonProperty(value="jobShapeConfigDetails")
        private JobShapeConfigDetails jobShapeConfigDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder blockStorageSizeInGBs(Integer blockStorageSizeInGBs) {
            this.blockStorageSizeInGBs = blockStorageSizeInGBs;
            this.__explicitlySet__.add("blockStorageSizeInGBs");
            return this;
        }

        public Builder jobShapeConfigDetails(JobShapeConfigDetails jobShapeConfigDetails) {
            this.jobShapeConfigDetails = jobShapeConfigDetails;
            this.__explicitlySet__.add("jobShapeConfigDetails");
            return this;
        }

        public StandaloneJobInfrastructureConfigurationDetails build() {
            StandaloneJobInfrastructureConfigurationDetails model = new StandaloneJobInfrastructureConfigurationDetails(this.shapeName, this.subnetId, this.blockStorageSizeInGBs, this.jobShapeConfigDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StandaloneJobInfrastructureConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("blockStorageSizeInGBs")) {
                this.blockStorageSizeInGBs(model.getBlockStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("jobShapeConfigDetails")) {
                this.jobShapeConfigDetails(model.getJobShapeConfigDetails());
            }
            return this;
        }
    }
}

