/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.ArtifactExportDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="artifactSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ArtifactExportDetailsObjectStorage
extends ArtifactExportDetails {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="sourceBucket")
    private final String sourceBucket;
    @JsonProperty(value="sourceObjectName")
    private final String sourceObjectName;
    @JsonProperty(value="sourceRegion")
    private final String sourceRegion;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ArtifactExportDetailsObjectStorage(String namespace, String sourceBucket, String sourceObjectName, String sourceRegion) {
        this.namespace = namespace;
        this.sourceBucket = sourceBucket;
        this.sourceObjectName = sourceObjectName;
        this.sourceRegion = sourceRegion;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public String getSourceObjectName() {
        return this.sourceObjectName;
    }

    public String getSourceRegion() {
        return this.sourceRegion;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ArtifactExportDetailsObjectStorage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", sourceBucket=").append(String.valueOf(this.sourceBucket));
        sb.append(", sourceObjectName=").append(String.valueOf(this.sourceObjectName));
        sb.append(", sourceRegion=").append(String.valueOf(this.sourceRegion));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactExportDetailsObjectStorage)) {
            return false;
        }
        ArtifactExportDetailsObjectStorage other = (ArtifactExportDetailsObjectStorage)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.sourceBucket, other.sourceBucket) && Objects.equals(this.sourceObjectName, other.sourceObjectName) && Objects.equals(this.sourceRegion, other.sourceRegion) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.sourceBucket == null ? 43 : this.sourceBucket.hashCode());
        result = result * 59 + (this.sourceObjectName == null ? 43 : this.sourceObjectName.hashCode());
        result = result * 59 + (this.sourceRegion == null ? 43 : this.sourceRegion.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="sourceBucket")
        private String sourceBucket;
        @JsonProperty(value="sourceObjectName")
        private String sourceObjectName;
        @JsonProperty(value="sourceRegion")
        private String sourceRegion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder sourceBucket(String sourceBucket) {
            this.sourceBucket = sourceBucket;
            this.__explicitlySet__.add("sourceBucket");
            return this;
        }

        public Builder sourceObjectName(String sourceObjectName) {
            this.sourceObjectName = sourceObjectName;
            this.__explicitlySet__.add("sourceObjectName");
            return this;
        }

        public Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            this.__explicitlySet__.add("sourceRegion");
            return this;
        }

        public ArtifactExportDetailsObjectStorage build() {
            ArtifactExportDetailsObjectStorage model = new ArtifactExportDetailsObjectStorage(this.namespace, this.sourceBucket, this.sourceObjectName, this.sourceRegion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ArtifactExportDetailsObjectStorage model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("sourceBucket")) {
                this.sourceBucket(model.getSourceBucket());
            }
            if (model.wasPropertyExplicitlySet("sourceObjectName")) {
                this.sourceObjectName(model.getSourceObjectName());
            }
            if (model.wasPropertyExplicitlySet("sourceRegion")) {
                this.sourceRegion(model.getSourceRegion());
            }
            return this;
        }
    }
}

