/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datascience.DataScience;
import com.oracle.bmc.datascience.DataScienceAsyncClient;
import com.oracle.bmc.datascience.DataSciencePaginators;
import com.oracle.bmc.datascience.DataScienceWaiters;
import com.oracle.bmc.datascience.model.FastLaunchJobConfigSummary;
import com.oracle.bmc.datascience.model.Job;
import com.oracle.bmc.datascience.model.JobRun;
import com.oracle.bmc.datascience.model.JobRunSummary;
import com.oracle.bmc.datascience.model.JobShapeSummary;
import com.oracle.bmc.datascience.model.JobSummary;
import com.oracle.bmc.datascience.model.Model;
import com.oracle.bmc.datascience.model.ModelDeployment;
import com.oracle.bmc.datascience.model.ModelDeploymentShapeSummary;
import com.oracle.bmc.datascience.model.ModelDeploymentSummary;
import com.oracle.bmc.datascience.model.ModelProvenance;
import com.oracle.bmc.datascience.model.ModelSummary;
import com.oracle.bmc.datascience.model.NotebookSession;
import com.oracle.bmc.datascience.model.NotebookSessionShapeSummary;
import com.oracle.bmc.datascience.model.NotebookSessionSummary;
import com.oracle.bmc.datascience.model.Project;
import com.oracle.bmc.datascience.model.ProjectSummary;
import com.oracle.bmc.datascience.model.WorkRequest;
import com.oracle.bmc.datascience.model.WorkRequestError;
import com.oracle.bmc.datascience.model.WorkRequestLogEntry;
import com.oracle.bmc.datascience.model.WorkRequestSummary;
import com.oracle.bmc.datascience.requests.ActivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.ActivateModelRequest;
import com.oracle.bmc.datascience.requests.ActivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CancelJobRunRequest;
import com.oracle.bmc.datascience.requests.CancelWorkRequestRequest;
import com.oracle.bmc.datascience.requests.ChangeJobCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeJobRunCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeModelDeploymentCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeNotebookSessionCompartmentRequest;
import com.oracle.bmc.datascience.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.datascience.requests.CreateJobArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateJobRequest;
import com.oracle.bmc.datascience.requests.CreateJobRunRequest;
import com.oracle.bmc.datascience.requests.CreateModelArtifactRequest;
import com.oracle.bmc.datascience.requests.CreateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.CreateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.CreateModelRequest;
import com.oracle.bmc.datascience.requests.CreateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.CreateProjectRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeactivateModelRequest;
import com.oracle.bmc.datascience.requests.DeactivateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteJobRequest;
import com.oracle.bmc.datascience.requests.DeleteJobRunRequest;
import com.oracle.bmc.datascience.requests.DeleteModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.DeleteModelRequest;
import com.oracle.bmc.datascience.requests.DeleteNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.DeleteProjectRequest;
import com.oracle.bmc.datascience.requests.ExportModelArtifactRequest;
import com.oracle.bmc.datascience.requests.GetJobArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetJobRequest;
import com.oracle.bmc.datascience.requests.GetJobRunRequest;
import com.oracle.bmc.datascience.requests.GetModelArtifactContentRequest;
import com.oracle.bmc.datascience.requests.GetModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.GetModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.GetModelRequest;
import com.oracle.bmc.datascience.requests.GetNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.GetProjectRequest;
import com.oracle.bmc.datascience.requests.GetWorkRequestRequest;
import com.oracle.bmc.datascience.requests.HeadJobArtifactRequest;
import com.oracle.bmc.datascience.requests.HeadModelArtifactRequest;
import com.oracle.bmc.datascience.requests.ImportModelArtifactRequest;
import com.oracle.bmc.datascience.requests.ListFastLaunchJobConfigsRequest;
import com.oracle.bmc.datascience.requests.ListJobRunsRequest;
import com.oracle.bmc.datascience.requests.ListJobShapesRequest;
import com.oracle.bmc.datascience.requests.ListJobsRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentShapesRequest;
import com.oracle.bmc.datascience.requests.ListModelDeploymentsRequest;
import com.oracle.bmc.datascience.requests.ListModelsRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionShapesRequest;
import com.oracle.bmc.datascience.requests.ListNotebookSessionsRequest;
import com.oracle.bmc.datascience.requests.ListProjectsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datascience.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datascience.requests.UpdateJobRequest;
import com.oracle.bmc.datascience.requests.UpdateJobRunRequest;
import com.oracle.bmc.datascience.requests.UpdateModelDeploymentRequest;
import com.oracle.bmc.datascience.requests.UpdateModelProvenanceRequest;
import com.oracle.bmc.datascience.requests.UpdateModelRequest;
import com.oracle.bmc.datascience.requests.UpdateNotebookSessionRequest;
import com.oracle.bmc.datascience.requests.UpdateProjectRequest;
import com.oracle.bmc.datascience.responses.ActivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.ActivateModelResponse;
import com.oracle.bmc.datascience.responses.ActivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CancelJobRunResponse;
import com.oracle.bmc.datascience.responses.CancelWorkRequestResponse;
import com.oracle.bmc.datascience.responses.ChangeJobCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeJobRunCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeModelDeploymentCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeNotebookSessionCompartmentResponse;
import com.oracle.bmc.datascience.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.datascience.responses.CreateJobArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateJobResponse;
import com.oracle.bmc.datascience.responses.CreateJobRunResponse;
import com.oracle.bmc.datascience.responses.CreateModelArtifactResponse;
import com.oracle.bmc.datascience.responses.CreateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.CreateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.CreateModelResponse;
import com.oracle.bmc.datascience.responses.CreateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.CreateProjectResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeactivateModelResponse;
import com.oracle.bmc.datascience.responses.DeactivateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteJobResponse;
import com.oracle.bmc.datascience.responses.DeleteJobRunResponse;
import com.oracle.bmc.datascience.responses.DeleteModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.DeleteModelResponse;
import com.oracle.bmc.datascience.responses.DeleteNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.DeleteProjectResponse;
import com.oracle.bmc.datascience.responses.ExportModelArtifactResponse;
import com.oracle.bmc.datascience.responses.GetJobArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetJobResponse;
import com.oracle.bmc.datascience.responses.GetJobRunResponse;
import com.oracle.bmc.datascience.responses.GetModelArtifactContentResponse;
import com.oracle.bmc.datascience.responses.GetModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.GetModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.GetModelResponse;
import com.oracle.bmc.datascience.responses.GetNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.GetProjectResponse;
import com.oracle.bmc.datascience.responses.GetWorkRequestResponse;
import com.oracle.bmc.datascience.responses.HeadJobArtifactResponse;
import com.oracle.bmc.datascience.responses.HeadModelArtifactResponse;
import com.oracle.bmc.datascience.responses.ImportModelArtifactResponse;
import com.oracle.bmc.datascience.responses.ListFastLaunchJobConfigsResponse;
import com.oracle.bmc.datascience.responses.ListJobRunsResponse;
import com.oracle.bmc.datascience.responses.ListJobShapesResponse;
import com.oracle.bmc.datascience.responses.ListJobsResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentShapesResponse;
import com.oracle.bmc.datascience.responses.ListModelDeploymentsResponse;
import com.oracle.bmc.datascience.responses.ListModelsResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionShapesResponse;
import com.oracle.bmc.datascience.responses.ListNotebookSessionsResponse;
import com.oracle.bmc.datascience.responses.ListProjectsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datascience.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datascience.responses.UpdateJobResponse;
import com.oracle.bmc.datascience.responses.UpdateJobRunResponse;
import com.oracle.bmc.datascience.responses.UpdateModelDeploymentResponse;
import com.oracle.bmc.datascience.responses.UpdateModelProvenanceResponse;
import com.oracle.bmc.datascience.responses.UpdateModelResponse;
import com.oracle.bmc.datascience.responses.UpdateNotebookSessionResponse;
import com.oracle.bmc.datascience.responses.UpdateProjectResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataScienceClient
extends BaseSyncClient
implements DataScience {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATASCIENCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datascience.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataScienceAsyncClient.class);
    private final DataScienceWaiters waiters;
    private final DataSciencePaginators paginators;

    private DataScienceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DataScience-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataScienceWaiters(executorService, this);
        this.paginators = new DataSciencePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ActivateModelResponse activateModel(ActivateModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (ActivateModelResponse)this.clientCall(request, ActivateModelResponse::builder).logger(LOG, "activateModel").serviceDetails("DataScience", "ActivateModel", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/ActivateModel").method(Method.POST).requestBuilder(ActivateModelRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, ActivateModelResponse.Builder::model).handleResponseHeaderString("etag", ActivateModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ActivateModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ActivateModelDeploymentResponse activateModelDeployment(ActivateModelDeploymentRequest request) {
        Validate.notBlank((String)request.getModelDeploymentId(), (String)"modelDeploymentId must not be blank", (Object[])new Object[0]);
        return (ActivateModelDeploymentResponse)this.clientCall(request, ActivateModelDeploymentResponse::builder).logger(LOG, "activateModelDeployment").serviceDetails("DataScience", "ActivateModelDeployment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/ActivateModelDeployment").method(Method.POST).requestBuilder(ActivateModelDeploymentRequest::builder).basePath("/20190101").appendPathParam("modelDeployments").appendPathParam(request.getModelDeploymentId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", ActivateModelDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ActivateModelDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ActivateNotebookSessionResponse activateNotebookSession(ActivateNotebookSessionRequest request) {
        Validate.notBlank((String)request.getNotebookSessionId(), (String)"notebookSessionId must not be blank", (Object[])new Object[0]);
        return (ActivateNotebookSessionResponse)this.clientCall(request, ActivateNotebookSessionResponse::builder).logger(LOG, "activateNotebookSession").serviceDetails("DataScience", "ActivateNotebookSession", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/ActivateNotebookSession").method(Method.POST).requestBuilder(ActivateNotebookSessionRequest::builder).basePath("/20190101").appendPathParam("notebookSessions").appendPathParam(request.getNotebookSessionId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", ActivateNotebookSessionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ActivateNotebookSessionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelJobRunResponse cancelJobRun(CancelJobRunRequest request) {
        Validate.notBlank((String)request.getJobRunId(), (String)"jobRunId must not be blank", (Object[])new Object[0]);
        return (CancelJobRunResponse)this.clientCall(request, CancelJobRunResponse::builder).logger(LOG, "cancelJobRun").serviceDetails("DataScience", "CancelJobRun", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/CancelJobRun").method(Method.POST).requestBuilder(CancelJobRunRequest::builder).basePath("/20190101").appendPathParam("jobRuns").appendPathParam(request.getJobRunId()).appendPathParam("actions").appendPathParam("cancelJobRun").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", CancelJobRunResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("DataScience", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20190101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeJobCompartmentResponse changeJobCompartment(ChangeJobCompartmentRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeJobCompartmentDetails(), "changeJobCompartmentDetails is required");
        return (ChangeJobCompartmentResponse)this.clientCall(request, ChangeJobCompartmentResponse::builder).logger(LOG, "changeJobCompartment").serviceDetails("DataScience", "ChangeJobCompartment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/ChangeJobCompartment").method(Method.POST).requestBuilder(ChangeJobCompartmentRequest::builder).basePath("/20190101").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeJobCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeJobRunCompartmentResponse changeJobRunCompartment(ChangeJobRunCompartmentRequest request) {
        Validate.notBlank((String)request.getJobRunId(), (String)"jobRunId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeJobRunCompartmentDetails(), "changeJobRunCompartmentDetails is required");
        return (ChangeJobRunCompartmentResponse)this.clientCall(request, ChangeJobRunCompartmentResponse::builder).logger(LOG, "changeJobRunCompartment").serviceDetails("DataScience", "ChangeJobRunCompartment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/ChangeJobRunCompartment").method(Method.POST).requestBuilder(ChangeJobRunCompartmentRequest::builder).basePath("/20190101").appendPathParam("jobRuns").appendPathParam(request.getJobRunId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeJobRunCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeModelCompartmentResponse changeModelCompartment(ChangeModelCompartmentRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelCompartmentDetails(), "changeModelCompartmentDetails is required");
        return (ChangeModelCompartmentResponse)this.clientCall(request, ChangeModelCompartmentResponse::builder).logger(LOG, "changeModelCompartment").serviceDetails("DataScience", "ChangeModelCompartment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/ChangeModelCompartment").method(Method.POST).requestBuilder(ChangeModelCompartmentRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeModelDeploymentCompartmentResponse changeModelDeploymentCompartment(ChangeModelDeploymentCompartmentRequest request) {
        Validate.notBlank((String)request.getModelDeploymentId(), (String)"modelDeploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelDeploymentCompartmentDetails(), "changeModelDeploymentCompartmentDetails is required");
        return (ChangeModelDeploymentCompartmentResponse)this.clientCall(request, ChangeModelDeploymentCompartmentResponse::builder).logger(LOG, "changeModelDeploymentCompartment").serviceDetails("DataScience", "ChangeModelDeploymentCompartment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/ChangeModelDeploymentCompartment").method(Method.POST).requestBuilder(ChangeModelDeploymentCompartmentRequest::builder).basePath("/20190101").appendPathParam("modelDeployments").appendPathParam(request.getModelDeploymentId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelDeploymentCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeNotebookSessionCompartmentResponse changeNotebookSessionCompartment(ChangeNotebookSessionCompartmentRequest request) {
        Validate.notBlank((String)request.getNotebookSessionId(), (String)"notebookSessionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNotebookSessionCompartmentDetails(), "changeNotebookSessionCompartmentDetails is required");
        return (ChangeNotebookSessionCompartmentResponse)this.clientCall(request, ChangeNotebookSessionCompartmentResponse::builder).logger(LOG, "changeNotebookSessionCompartment").serviceDetails("DataScience", "ChangeNotebookSessionCompartment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/ChangeNotebookSessionCompartment").method(Method.POST).requestBuilder(ChangeNotebookSessionCompartmentRequest::builder).basePath("/20190101").appendPathParam("notebookSessions").appendPathParam(request.getNotebookSessionId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeNotebookSessionCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return (ChangeProjectCompartmentResponse)this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("DataScience", "ChangeProjectCompartment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/ChangeProjectCompartment").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20190101").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        Objects.requireNonNull(request.getCreateJobDetails(), "createJobDetails is required");
        return (CreateJobResponse)this.clientCall(request, CreateJobResponse::builder).logger(LOG, "createJob").serviceDetails("DataScience", "CreateJob", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/CreateJob").method(Method.POST).requestBuilder(CreateJobRequest::builder).basePath("/20190101").appendPathParam("jobs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Job.class, CreateJobResponse.Builder::job).handleResponseHeaderString("etag", CreateJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateJobArtifactResponse createJobArtifact(CreateJobArtifactRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getJobArtifact(), "jobArtifact is required");
        return (CreateJobArtifactResponse)this.clientCall(request, CreateJobArtifactResponse::builder).logger(LOG, "createJobArtifact").serviceDetails("DataScience", "CreateJobArtifact", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/CreateJobArtifact").method(Method.POST).requestBuilder(CreateJobArtifactRequest::builder).obmcsSigningStrategy(SigningStrategy.EXCLUDE_BODY).basePath("/20190101").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("artifact").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("content-length", (Number)request.getContentLength()).appendHeader("content-disposition", request.getContentDisposition()).hasBinaryRequestBody().hasBody().handleResponseHeaderString("etag", CreateJobArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateJobArtifactResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJobRunResponse createJobRun(CreateJobRunRequest request) {
        Objects.requireNonNull(request.getCreateJobRunDetails(), "createJobRunDetails is required");
        return (CreateJobRunResponse)this.clientCall(request, CreateJobRunResponse::builder).logger(LOG, "createJobRun").serviceDetails("DataScience", "CreateJobRun", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/CreateJobRun").method(Method.POST).requestBuilder(CreateJobRunRequest::builder).basePath("/20190101").appendPathParam("jobRuns").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(JobRun.class, CreateJobRunResponse.Builder::jobRun).handleResponseHeaderString("etag", CreateJobRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateJobRunResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        Objects.requireNonNull(request.getCreateModelDetails(), "createModelDetails is required");
        return (CreateModelResponse)this.clientCall(request, CreateModelResponse::builder).logger(LOG, "createModel").serviceDetails("DataScience", "CreateModel", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/CreateModel").method(Method.POST).requestBuilder(CreateModelRequest::builder).basePath("/20190101").appendPathParam("models").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Model.class, CreateModelResponse.Builder::model).handleResponseHeaderString("etag", CreateModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateModelArtifactResponse createModelArtifact(CreateModelArtifactRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getModelArtifact(), "modelArtifact is required");
        return (CreateModelArtifactResponse)this.clientCall(request, CreateModelArtifactResponse::builder).logger(LOG, "createModelArtifact").serviceDetails("DataScience", "CreateModelArtifact", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/CreateModelArtifact").method(Method.POST).requestBuilder(CreateModelArtifactRequest::builder).obmcsSigningStrategy(SigningStrategy.EXCLUDE_BODY).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("artifact").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("content-length", (Number)request.getContentLength()).appendHeader("content-disposition", request.getContentDisposition()).appendHeader("if-match", request.getIfMatch()).hasBinaryRequestBody().hasBody().handleResponseHeaderString("etag", CreateModelArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateModelArtifactResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateModelDeploymentResponse createModelDeployment(CreateModelDeploymentRequest request) {
        Objects.requireNonNull(request.getCreateModelDeploymentDetails(), "createModelDeploymentDetails is required");
        return (CreateModelDeploymentResponse)this.clientCall(request, CreateModelDeploymentResponse::builder).logger(LOG, "createModelDeployment").serviceDetails("DataScience", "CreateModelDeployment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/CreateModelDeployment").method(Method.POST).requestBuilder(CreateModelDeploymentRequest::builder).basePath("/20190101").appendPathParam("modelDeployments").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ModelDeployment.class, CreateModelDeploymentResponse.Builder::modelDeployment).handleResponseHeaderString("etag", CreateModelDeploymentResponse.Builder::etag).handleResponseHeaderString("location", CreateModelDeploymentResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateModelDeploymentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateModelDeploymentResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateModelProvenanceResponse createModelProvenance(CreateModelProvenanceRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateModelProvenanceDetails(), "createModelProvenanceDetails is required");
        return (CreateModelProvenanceResponse)this.clientCall(request, CreateModelProvenanceResponse::builder).logger(LOG, "createModelProvenance").serviceDetails("DataScience", "CreateModelProvenance", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/CreateModelProvenance").method(Method.POST).requestBuilder(CreateModelProvenanceRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("provenance").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ModelProvenance.class, CreateModelProvenanceResponse.Builder::modelProvenance).handleResponseHeaderString("opc-request-id", CreateModelProvenanceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateModelProvenanceResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateNotebookSessionResponse createNotebookSession(CreateNotebookSessionRequest request) {
        Objects.requireNonNull(request.getCreateNotebookSessionDetails(), "createNotebookSessionDetails is required");
        return (CreateNotebookSessionResponse)this.clientCall(request, CreateNotebookSessionResponse::builder).logger(LOG, "createNotebookSession").serviceDetails("DataScience", "CreateNotebookSession", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/CreateNotebookSession").method(Method.POST).requestBuilder(CreateNotebookSessionRequest::builder).basePath("/20190101").appendPathParam("notebookSessions").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(NotebookSession.class, CreateNotebookSessionResponse.Builder::notebookSession).handleResponseHeaderString("etag", CreateNotebookSessionResponse.Builder::etag).handleResponseHeaderString("location", CreateNotebookSessionResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreateNotebookSessionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateNotebookSessionResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return (CreateProjectResponse)this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("DataScience", "CreateProject", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/CreateProject").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20190101").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeactivateModelResponse deactivateModel(DeactivateModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (DeactivateModelResponse)this.clientCall(request, DeactivateModelResponse::builder).logger(LOG, "deactivateModel").serviceDetails("DataScience", "DeactivateModel", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/DeactivateModel").method(Method.POST).requestBuilder(DeactivateModelRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("deactivate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, DeactivateModelResponse.Builder::model).handleResponseHeaderString("etag", DeactivateModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", DeactivateModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeactivateModelDeploymentResponse deactivateModelDeployment(DeactivateModelDeploymentRequest request) {
        Validate.notBlank((String)request.getModelDeploymentId(), (String)"modelDeploymentId must not be blank", (Object[])new Object[0]);
        return (DeactivateModelDeploymentResponse)this.clientCall(request, DeactivateModelDeploymentResponse::builder).logger(LOG, "deactivateModelDeployment").serviceDetails("DataScience", "DeactivateModelDeployment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/DeactivateModelDeployment").method(Method.POST).requestBuilder(DeactivateModelDeploymentRequest::builder).basePath("/20190101").appendPathParam("modelDeployments").appendPathParam(request.getModelDeploymentId()).appendPathParam("actions").appendPathParam("deactivate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeactivateModelDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeactivateModelDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeactivateNotebookSessionResponse deactivateNotebookSession(DeactivateNotebookSessionRequest request) {
        Validate.notBlank((String)request.getNotebookSessionId(), (String)"notebookSessionId must not be blank", (Object[])new Object[0]);
        return (DeactivateNotebookSessionResponse)this.clientCall(request, DeactivateNotebookSessionResponse::builder).logger(LOG, "deactivateNotebookSession").serviceDetails("DataScience", "DeactivateNotebookSession", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/DeactivateNotebookSession").method(Method.POST).requestBuilder(DeactivateNotebookSessionRequest::builder).basePath("/20190101").appendPathParam("notebookSessions").appendPathParam(request.getNotebookSessionId()).appendPathParam("actions").appendPathParam("deactivate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeactivateNotebookSessionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeactivateNotebookSessionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (DeleteJobResponse)this.clientCall(request, DeleteJobResponse::builder).logger(LOG, "deleteJob").serviceDetails("DataScience", "DeleteJob", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/DeleteJob").method(Method.DELETE).requestBuilder(DeleteJobRequest::builder).basePath("/20190101").appendPathParam("jobs").appendPathParam(request.getJobId()).appendQueryParam("deleteRelatedJobRuns", (Object)request.getDeleteRelatedJobRuns()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteJobResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteJobRunResponse deleteJobRun(DeleteJobRunRequest request) {
        Validate.notBlank((String)request.getJobRunId(), (String)"jobRunId must not be blank", (Object[])new Object[0]);
        return (DeleteJobRunResponse)this.clientCall(request, DeleteJobRunResponse::builder).logger(LOG, "deleteJobRun").serviceDetails("DataScience", "DeleteJobRun", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/DeleteJobRun").method(Method.DELETE).requestBuilder(DeleteJobRunRequest::builder).basePath("/20190101").appendPathParam("jobRuns").appendPathParam(request.getJobRunId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteJobRunResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (DeleteModelResponse)this.clientCall(request, DeleteModelResponse::builder).logger(LOG, "deleteModel").serviceDetails("DataScience", "DeleteModel", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/DeleteModel").method(Method.DELETE).requestBuilder(DeleteModelRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteModelDeploymentResponse deleteModelDeployment(DeleteModelDeploymentRequest request) {
        Validate.notBlank((String)request.getModelDeploymentId(), (String)"modelDeploymentId must not be blank", (Object[])new Object[0]);
        return (DeleteModelDeploymentResponse)this.clientCall(request, DeleteModelDeploymentResponse::builder).logger(LOG, "deleteModelDeployment").serviceDetails("DataScience", "DeleteModelDeployment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/DeleteModelDeployment").method(Method.DELETE).requestBuilder(DeleteModelDeploymentRequest::builder).basePath("/20190101").appendPathParam("modelDeployments").appendPathParam(request.getModelDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteModelDeploymentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteModelDeploymentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteNotebookSessionResponse deleteNotebookSession(DeleteNotebookSessionRequest request) {
        Validate.notBlank((String)request.getNotebookSessionId(), (String)"notebookSessionId must not be blank", (Object[])new Object[0]);
        return (DeleteNotebookSessionResponse)this.clientCall(request, DeleteNotebookSessionResponse::builder).logger(LOG, "deleteNotebookSession").serviceDetails("DataScience", "DeleteNotebookSession", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/DeleteNotebookSession").method(Method.DELETE).requestBuilder(DeleteNotebookSessionRequest::builder).basePath("/20190101").appendPathParam("notebookSessions").appendPathParam(request.getNotebookSessionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNotebookSessionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNotebookSessionResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (DeleteProjectResponse)this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("DataScience", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20190101").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ExportModelArtifactResponse exportModelArtifact(ExportModelArtifactRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportModelArtifactDetails(), "exportModelArtifactDetails is required");
        return (ExportModelArtifactResponse)this.clientCall(request, ExportModelArtifactResponse::builder).logger(LOG, "exportModelArtifact").serviceDetails("DataScience", "ExportModelArtifact", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/ExportModelArtifact").method(Method.POST).requestBuilder(ExportModelArtifactRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("exportArtifact").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ExportModelArtifactResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ExportModelArtifactResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobResponse)this.clientCall(request, GetJobResponse::builder).logger(LOG, "getJob").serviceDetails("DataScience", "GetJob", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/GetJob").method(Method.GET).requestBuilder(GetJobRequest::builder).basePath("/20190101").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Job.class, GetJobResponse.Builder::job).handleResponseHeaderString("etag", GetJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobArtifactContentResponse getJobArtifactContent(GetJobArtifactContentRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (GetJobArtifactContentResponse)this.clientCall(request, GetJobArtifactContentResponse::builder).logger(LOG, "getJobArtifactContent").serviceDetails("DataScience", "GetJobArtifactContent", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/GetJobArtifactContent").method(Method.GET).requestBuilder(GetJobArtifactContentRequest::builder).basePath("/20190101").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("artifact").appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("range", request.getRange()).handleBody(InputStream.class, GetJobArtifactContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetJobArtifactContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobArtifactContentResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GetJobArtifactContentResponse.Builder::contentLength).handleResponseHeaderString("content-md5", GetJobArtifactContentResponse.Builder::contentMd5).handleResponseHeaderDate("last-modified", GetJobArtifactContentResponse.Builder::lastModified).handleResponseHeaderString("content-disposition", GetJobArtifactContentResponse.Builder::contentDisposition).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetJobRunResponse getJobRun(GetJobRunRequest request) {
        Validate.notBlank((String)request.getJobRunId(), (String)"jobRunId must not be blank", (Object[])new Object[0]);
        return (GetJobRunResponse)this.clientCall(request, GetJobRunResponse::builder).logger(LOG, "getJobRun").serviceDetails("DataScience", "GetJobRun", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/GetJobRun").method(Method.GET).requestBuilder(GetJobRunRequest::builder).basePath("/20190101").appendPathParam("jobRuns").appendPathParam(request.getJobRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(JobRun.class, GetJobRunResponse.Builder::jobRun).handleResponseHeaderString("etag", GetJobRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJobRunResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (GetModelResponse)this.clientCall(request, GetModelResponse::builder).logger(LOG, "getModel").serviceDetails("DataScience", "GetModel", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/GetModel").method(Method.GET).requestBuilder(GetModelRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, GetModelResponse.Builder::model).handleResponseHeaderString("etag", GetModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetModelArtifactContentResponse getModelArtifactContent(GetModelArtifactContentRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (GetModelArtifactContentResponse)this.clientCall(request, GetModelArtifactContentResponse::builder).logger(LOG, "getModelArtifactContent").serviceDetails("DataScience", "GetModelArtifactContent", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/GetModelArtifactContent").method(Method.GET).requestBuilder(GetModelArtifactContentRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("artifact").appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("range", request.getRange()).handleBody(InputStream.class, GetModelArtifactContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetModelArtifactContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelArtifactContentResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GetModelArtifactContentResponse.Builder::contentLength).handleResponseHeaderString("content-disposition", GetModelArtifactContentResponse.Builder::contentDisposition).handleResponseHeaderString("content-md5", GetModelArtifactContentResponse.Builder::contentMd5).handleResponseHeaderDate("last-modified", GetModelArtifactContentResponse.Builder::lastModified).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetModelDeploymentResponse getModelDeployment(GetModelDeploymentRequest request) {
        Validate.notBlank((String)request.getModelDeploymentId(), (String)"modelDeploymentId must not be blank", (Object[])new Object[0]);
        return (GetModelDeploymentResponse)this.clientCall(request, GetModelDeploymentResponse::builder).logger(LOG, "getModelDeployment").serviceDetails("DataScience", "GetModelDeployment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/GetModelDeployment").method(Method.GET).requestBuilder(GetModelDeploymentRequest::builder).basePath("/20190101").appendPathParam("modelDeployments").appendPathParam(request.getModelDeploymentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelDeployment.class, GetModelDeploymentResponse.Builder::modelDeployment).handleResponseHeaderString("etag", GetModelDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelDeploymentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetModelProvenanceResponse getModelProvenance(GetModelProvenanceRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (GetModelProvenanceResponse)this.clientCall(request, GetModelProvenanceResponse::builder).logger(LOG, "getModelProvenance").serviceDetails("DataScience", "GetModelProvenance", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/GetModelProvenance").method(Method.GET).requestBuilder(GetModelProvenanceRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("provenance").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelProvenance.class, GetModelProvenanceResponse.Builder::modelProvenance).handleResponseHeaderString("etag", GetModelProvenanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelProvenanceResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetNotebookSessionResponse getNotebookSession(GetNotebookSessionRequest request) {
        Validate.notBlank((String)request.getNotebookSessionId(), (String)"notebookSessionId must not be blank", (Object[])new Object[0]);
        return (GetNotebookSessionResponse)this.clientCall(request, GetNotebookSessionResponse::builder).logger(LOG, "getNotebookSession").serviceDetails("DataScience", "GetNotebookSession", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/GetNotebookSession").method(Method.GET).requestBuilder(GetNotebookSessionRequest::builder).basePath("/20190101").appendPathParam("notebookSessions").appendPathParam(request.getNotebookSessionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NotebookSession.class, GetNotebookSessionResponse.Builder::notebookSession).handleResponseHeaderString("etag", GetNotebookSessionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNotebookSessionResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (GetProjectResponse)this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("DataScience", "GetProject", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20190101").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DataScience", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public HeadJobArtifactResponse headJobArtifact(HeadJobArtifactRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        return (HeadJobArtifactResponse)this.clientCall(request, HeadJobArtifactResponse::builder).logger(LOG, "headJobArtifact").serviceDetails("DataScience", "HeadJobArtifact", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/HeadJobArtifact").method(Method.HEAD).requestBuilder(HeadJobArtifactRequest::builder).basePath("/20190101").appendPathParam("jobs").appendPathParam(request.getJobId()).appendPathParam("artifact").appendPathParam("content").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("etag", HeadJobArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", HeadJobArtifactResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", HeadJobArtifactResponse.Builder::contentLength).handleResponseHeaderString("content-md5", HeadJobArtifactResponse.Builder::contentMd5).handleResponseHeaderString("content-disposition", HeadJobArtifactResponse.Builder::contentDisposition).handleResponseHeaderDate("last-modified", HeadJobArtifactResponse.Builder::lastModified).operationUsesDefaultRetries().callSync();
    }

    @Override
    public HeadModelArtifactResponse headModelArtifact(HeadModelArtifactRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (HeadModelArtifactResponse)this.clientCall(request, HeadModelArtifactResponse::builder).logger(LOG, "headModelArtifact").serviceDetails("DataScience", "HeadModelArtifact", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/HeadModelArtifact").method(Method.HEAD).requestBuilder(HeadModelArtifactRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("artifact").appendPathParam("content").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("etag", HeadModelArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", HeadModelArtifactResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", HeadModelArtifactResponse.Builder::contentLength).handleResponseHeaderString("content-disposition", HeadModelArtifactResponse.Builder::contentDisposition).handleResponseHeaderString("content-md5", HeadModelArtifactResponse.Builder::contentMd5).handleResponseHeaderDate("last-modified", HeadModelArtifactResponse.Builder::lastModified).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ImportModelArtifactResponse importModelArtifact(ImportModelArtifactRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getImportModelArtifactDetails(), "importModelArtifactDetails is required");
        return (ImportModelArtifactResponse)this.clientCall(request, ImportModelArtifactResponse::builder).logger(LOG, "importModelArtifact").serviceDetails("DataScience", "ImportModelArtifact", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/ImportModelArtifact").method(Method.POST).requestBuilder(ImportModelArtifactRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("importArtifact").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", ImportModelArtifactResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ImportModelArtifactResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ListFastLaunchJobConfigsResponse listFastLaunchJobConfigs(ListFastLaunchJobConfigsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListFastLaunchJobConfigsResponse)this.clientCall(request, ListFastLaunchJobConfigsResponse::builder).logger(LOG, "listFastLaunchJobConfigs").serviceDetails("DataScience", "ListFastLaunchJobConfigs", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/FastLaunchJobConfigSummary/ListFastLaunchJobConfigs").method(Method.GET).requestBuilder(ListFastLaunchJobConfigsRequest::builder).basePath("/20190101").appendPathParam("fastLaunchJobConfigs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(FastLaunchJobConfigSummary.class, ListFastLaunchJobConfigsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListFastLaunchJobConfigsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListFastLaunchJobConfigsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListFastLaunchJobConfigsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobRunsResponse listJobRuns(ListJobRunsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJobRunsResponse)this.clientCall(request, ListJobRunsResponse::builder).logger(LOG, "listJobRuns").serviceDetails("DataScience", "ListJobRuns", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRunSummary/ListJobRuns").method(Method.GET).requestBuilder(ListJobRunsRequest::builder).basePath("/20190101").appendPathParam("jobRuns").appendQueryParam("id", (Object)request.getId()).appendQueryParam("jobId", (Object)request.getJobId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("createdBy", (Object)request.getCreatedBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(JobRunSummary.class, ListJobRunsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListJobRunsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListJobRunsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListJobRunsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobShapesResponse listJobShapes(ListJobShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJobShapesResponse)this.clientCall(request, ListJobShapesResponse::builder).logger(LOG, "listJobShapes").serviceDetails("DataScience", "ListJobShapes", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobShapeSummary/ListJobShapes").method(Method.GET).requestBuilder(ListJobShapesRequest::builder).basePath("/20190101").appendPathParam("jobShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(JobShapeSummary.class, ListJobShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListJobShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListJobShapesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListJobShapesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListJobsResponse)this.clientCall(request, ListJobsResponse::builder).logger(LOG, "listJobs").serviceDetails("DataScience", "ListJobs", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobSummary/ListJobs").method(Method.GET).requestBuilder(ListJobsRequest::builder).basePath("/20190101").appendPathParam("jobs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("createdBy", (Object)request.getCreatedBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(JobSummary.class, ListJobsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListJobsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListJobsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListJobsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListModelDeploymentShapesResponse listModelDeploymentShapes(ListModelDeploymentShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListModelDeploymentShapesResponse)this.clientCall(request, ListModelDeploymentShapesResponse::builder).logger(LOG, "listModelDeploymentShapes").serviceDetails("DataScience", "ListModelDeploymentShapes", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeploymentShapeSummary/ListModelDeploymentShapes").method(Method.GET).requestBuilder(ListModelDeploymentShapesRequest::builder).basePath("/20190101").appendPathParam("modelDeploymentShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ModelDeploymentShapeSummary.class, ListModelDeploymentShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListModelDeploymentShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListModelDeploymentShapesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListModelDeploymentShapesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListModelDeploymentsResponse listModelDeployments(ListModelDeploymentsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListModelDeploymentsResponse)this.clientCall(request, ListModelDeploymentsResponse::builder).logger(LOG, "listModelDeployments").serviceDetails("DataScience", "ListModelDeployments", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeploymentSummary/ListModelDeployments").method(Method.GET).requestBuilder(ListModelDeploymentsRequest::builder).basePath("/20190101").appendPathParam("modelDeployments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("createdBy", (Object)request.getCreatedBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ModelDeploymentSummary.class, ListModelDeploymentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListModelDeploymentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListModelDeploymentsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListModelDeploymentsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListModelsResponse)this.clientCall(request, ListModelsResponse::builder).logger(LOG, "listModels").serviceDetails("DataScience", "ListModels", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelSummary/ListModels").method(Method.GET).requestBuilder(ListModelsRequest::builder).basePath("/20190101").appendPathParam("models").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("createdBy", (Object)request.getCreatedBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ModelSummary.class, ListModelsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListModelsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListModelsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListModelsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListNotebookSessionShapesResponse listNotebookSessionShapes(ListNotebookSessionShapesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListNotebookSessionShapesResponse)this.clientCall(request, ListNotebookSessionShapesResponse::builder).logger(LOG, "listNotebookSessionShapes").serviceDetails("DataScience", "ListNotebookSessionShapes", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSessionShapeSummary/ListNotebookSessionShapes").method(Method.GET).requestBuilder(ListNotebookSessionShapesRequest::builder).basePath("/20190101").appendPathParam("notebookSessionShapes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(NotebookSessionShapeSummary.class, ListNotebookSessionShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNotebookSessionShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListNotebookSessionShapesResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListNotebookSessionShapesResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListNotebookSessionsResponse listNotebookSessions(ListNotebookSessionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListNotebookSessionsResponse)this.clientCall(request, ListNotebookSessionsResponse::builder).logger(LOG, "listNotebookSessions").serviceDetails("DataScience", "ListNotebookSessions", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSessionSummary/ListNotebookSessions").method(Method.GET).requestBuilder(ListNotebookSessionsRequest::builder).basePath("/20190101").appendPathParam("notebookSessions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("createdBy", (Object)request.getCreatedBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(NotebookSessionSummary.class, ListNotebookSessionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListNotebookSessionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListNotebookSessionsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListNotebookSessionsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProjectsResponse)this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("DataScience", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ProjectSummary/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20190101").appendPathParam("projects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("createdBy", (Object)request.getCreatedBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ProjectSummary.class, ListProjectsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListProjectsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DataScience", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DataScience", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190101").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DataScience", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190101").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("operationType", (BmcEnum)request.getOperationType()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListWorkRequestsResponse.Builder::opcPrevPage).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest request) {
        Validate.notBlank((String)request.getJobId(), (String)"jobId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobDetails(), "updateJobDetails is required");
        return (UpdateJobResponse)this.clientCall(request, UpdateJobResponse::builder).logger(LOG, "updateJob").serviceDetails("DataScience", "UpdateJob", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Job/UpdateJob").method(Method.PUT).requestBuilder(UpdateJobRequest::builder).basePath("/20190101").appendPathParam("jobs").appendPathParam(request.getJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Job.class, UpdateJobResponse.Builder::job).handleResponseHeaderString("etag", UpdateJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateJobRunResponse updateJobRun(UpdateJobRunRequest request) {
        Validate.notBlank((String)request.getJobRunId(), (String)"jobRunId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJobRunDetails(), "updateJobRunDetails is required");
        return (UpdateJobRunResponse)this.clientCall(request, UpdateJobRunResponse::builder).logger(LOG, "updateJobRun").serviceDetails("DataScience", "UpdateJobRun", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/JobRun/UpdateJobRun").method(Method.PUT).requestBuilder(UpdateJobRunRequest::builder).basePath("/20190101").appendPathParam("jobRuns").appendPathParam(request.getJobRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(JobRun.class, UpdateJobRunResponse.Builder::jobRun).handleResponseHeaderString("etag", UpdateJobRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateJobRunResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDetails(), "updateModelDetails is required");
        return (UpdateModelResponse)this.clientCall(request, UpdateModelResponse::builder).logger(LOG, "updateModel").serviceDetails("DataScience", "UpdateModel", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/UpdateModel").method(Method.PUT).requestBuilder(UpdateModelRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, UpdateModelResponse.Builder::model).handleResponseHeaderString("etag", UpdateModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateModelDeploymentResponse updateModelDeployment(UpdateModelDeploymentRequest request) {
        Validate.notBlank((String)request.getModelDeploymentId(), (String)"modelDeploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDeploymentDetails(), "updateModelDeploymentDetails is required");
        return (UpdateModelDeploymentResponse)this.clientCall(request, UpdateModelDeploymentResponse::builder).logger(LOG, "updateModelDeployment").serviceDetails("DataScience", "UpdateModelDeployment", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/ModelDeployment/UpdateModelDeployment").method(Method.PUT).requestBuilder(UpdateModelDeploymentRequest::builder).basePath("/20190101").appendPathParam("modelDeployments").appendPathParam(request.getModelDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateModelDeploymentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateModelDeploymentResponse.Builder::opcWorkRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateModelProvenanceResponse updateModelProvenance(UpdateModelProvenanceRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelProvenanceDetails(), "updateModelProvenanceDetails is required");
        return (UpdateModelProvenanceResponse)this.clientCall(request, UpdateModelProvenanceResponse::builder).logger(LOG, "updateModelProvenance").serviceDetails("DataScience", "UpdateModelProvenance", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Model/UpdateModelProvenance").method(Method.PUT).requestBuilder(UpdateModelProvenanceRequest::builder).basePath("/20190101").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("provenance").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ModelProvenance.class, UpdateModelProvenanceResponse.Builder::modelProvenance).handleResponseHeaderString("opc-request-id", UpdateModelProvenanceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateModelProvenanceResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateNotebookSessionResponse updateNotebookSession(UpdateNotebookSessionRequest request) {
        Validate.notBlank((String)request.getNotebookSessionId(), (String)"notebookSessionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNotebookSessionDetails(), "updateNotebookSessionDetails is required");
        return (UpdateNotebookSessionResponse)this.clientCall(request, UpdateNotebookSessionResponse::builder).logger(LOG, "updateNotebookSession").serviceDetails("DataScience", "UpdateNotebookSession", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/NotebookSession/UpdateNotebookSession").method(Method.PUT).requestBuilder(UpdateNotebookSessionRequest::builder).basePath("/20190101").appendPathParam("notebookSessions").appendPathParam(request.getNotebookSessionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(NotebookSession.class, UpdateNotebookSessionResponse.Builder::notebookSession).handleResponseHeaderString("etag", UpdateNotebookSessionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateNotebookSessionResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return (UpdateProjectResponse)this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("DataScience", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/data-science/20190101/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20190101").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, UpdateProjectResponse.Builder::project).handleResponseHeaderString("etag", UpdateProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DataScienceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataSciencePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataScienceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataScienceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataScienceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataScienceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataScienceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataScienceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataScienceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataScienceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DataScienceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataScienceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataScienceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataScienceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataScienceClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

