/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class UploadMaskingPolicyRequest
extends BmcRequest<InputStream> {
    private InputStream uploadMaskingPolicyDetails;
    private String maskingPolicyId;
    private String ifMatch;
    private String opcRequestId;

    public InputStream getUploadMaskingPolicyDetails() {
        return this.uploadMaskingPolicyDetails;
    }

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.uploadMaskingPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().uploadMaskingPolicyDetails(this.uploadMaskingPolicyDetails).maskingPolicyId(this.maskingPolicyId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",uploadMaskingPolicyDetails=").append(String.valueOf(this.uploadMaskingPolicyDetails));
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadMaskingPolicyRequest)) {
            return false;
        }
        UploadMaskingPolicyRequest other = (UploadMaskingPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.uploadMaskingPolicyDetails, other.uploadMaskingPolicyDetails) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.uploadMaskingPolicyDetails == null ? 43 : this.uploadMaskingPolicyDetails.hashCode());
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UploadMaskingPolicyRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private InputStream uploadMaskingPolicyDetails = null;
        private String maskingPolicyId = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder uploadMaskingPolicyDetails(InputStream uploadMaskingPolicyDetails) {
            this.uploadMaskingPolicyDetails = uploadMaskingPolicyDetails;
            return this;
        }

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UploadMaskingPolicyRequest o) {
            this.uploadMaskingPolicyDetails(o.getUploadMaskingPolicyDetails());
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UploadMaskingPolicyRequest build() {
            UploadMaskingPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.uploadMaskingPolicyDetails(body);
            return this;
        }

        public UploadMaskingPolicyRequest buildWithoutInvocationCallback() {
            UploadMaskingPolicyRequest request = new UploadMaskingPolicyRequest();
            request.uploadMaskingPolicyDetails = this.uploadMaskingPolicyDetails;
            request.maskingPolicyId = this.maskingPolicyId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

