/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.MaskDataDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class MaskDataRequest
extends BmcRequest<MaskDataDetails> {
    private String maskingPolicyId;
    private MaskDataDetails maskDataDetails;
    private String opcRequestId;

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public MaskDataDetails getMaskDataDetails() {
        return this.maskDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public MaskDataDetails getBody$() {
        return this.maskDataDetails;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyId(this.maskingPolicyId).maskDataDetails(this.maskDataDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",maskDataDetails=").append(String.valueOf((Object)this.maskDataDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaskDataRequest)) {
            return false;
        }
        MaskDataRequest other = (MaskDataRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals((Object)this.maskDataDetails, (Object)other.maskDataDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.maskDataDetails == null ? 43 : this.maskDataDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<MaskDataRequest, MaskDataDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyId = null;
        private MaskDataDetails maskDataDetails = null;
        private String opcRequestId = null;

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder maskDataDetails(MaskDataDetails maskDataDetails) {
            this.maskDataDetails = maskDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(MaskDataRequest o) {
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.maskDataDetails(o.getMaskDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public MaskDataRequest build() {
            MaskDataRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(MaskDataDetails body) {
            this.maskDataDetails(body);
            return this;
        }

        public MaskDataRequest buildWithoutInvocationCallback() {
            MaskDataRequest request = new MaskDataRequest();
            request.maskingPolicyId = this.maskingPolicyId;
            request.maskDataDetails = this.maskDataDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

