/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datasafe.model.SensitiveColumnLifecycleState;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListSensitiveColumnsRequest
extends BmcRequest<Void> {
    private String sensitiveDataModelId;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Date timeCreatedLessThan;
    private Date timeUpdatedGreaterThanOrEqualTo;
    private Date timeUpdatedLessThan;
    private SensitiveColumnLifecycleState sensitiveColumnLifecycleState;
    private List<String> schemaName;
    private List<String> objectName;
    private List<String> columnName;
    private List<ObjectType> objectType;
    private List<String> dataType;
    private List<Status> status;
    private List<String> sensitiveTypeId;
    private List<String> parentColumnKey;
    private List<RelationType> relationType;
    private String columnGroup;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getSensitiveDataModelId() {
        return this.sensitiveDataModelId;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public Date getTimeUpdatedGreaterThanOrEqualTo() {
        return this.timeUpdatedGreaterThanOrEqualTo;
    }

    public Date getTimeUpdatedLessThan() {
        return this.timeUpdatedLessThan;
    }

    public SensitiveColumnLifecycleState getSensitiveColumnLifecycleState() {
        return this.sensitiveColumnLifecycleState;
    }

    public List<String> getSchemaName() {
        return this.schemaName;
    }

    public List<String> getObjectName() {
        return this.objectName;
    }

    public List<String> getColumnName() {
        return this.columnName;
    }

    public List<ObjectType> getObjectType() {
        return this.objectType;
    }

    public List<String> getDataType() {
        return this.dataType;
    }

    public List<Status> getStatus() {
        return this.status;
    }

    public List<String> getSensitiveTypeId() {
        return this.sensitiveTypeId;
    }

    public List<String> getParentColumnKey() {
        return this.parentColumnKey;
    }

    public List<RelationType> getRelationType() {
        return this.relationType;
    }

    public String getColumnGroup() {
        return this.columnGroup;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().sensitiveDataModelId(this.sensitiveDataModelId).timeCreatedGreaterThanOrEqualTo(this.timeCreatedGreaterThanOrEqualTo).timeCreatedLessThan(this.timeCreatedLessThan).timeUpdatedGreaterThanOrEqualTo(this.timeUpdatedGreaterThanOrEqualTo).timeUpdatedLessThan(this.timeUpdatedLessThan).sensitiveColumnLifecycleState(this.sensitiveColumnLifecycleState).schemaName(this.schemaName).objectName(this.objectName).columnName(this.columnName).objectType(this.objectType).dataType(this.dataType).status(this.status).sensitiveTypeId(this.sensitiveTypeId).parentColumnKey(this.parentColumnKey).relationType(this.relationType).columnGroup(this.columnGroup).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",sensitiveDataModelId=").append(String.valueOf(this.sensitiveDataModelId));
        sb.append(",timeCreatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCreatedGreaterThanOrEqualTo));
        sb.append(",timeCreatedLessThan=").append(String.valueOf(this.timeCreatedLessThan));
        sb.append(",timeUpdatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeUpdatedGreaterThanOrEqualTo));
        sb.append(",timeUpdatedLessThan=").append(String.valueOf(this.timeUpdatedLessThan));
        sb.append(",sensitiveColumnLifecycleState=").append(String.valueOf((Object)this.sensitiveColumnLifecycleState));
        sb.append(",schemaName=").append(String.valueOf(this.schemaName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",columnName=").append(String.valueOf(this.columnName));
        sb.append(",objectType=").append(String.valueOf(this.objectType));
        sb.append(",dataType=").append(String.valueOf(this.dataType));
        sb.append(",status=").append(String.valueOf(this.status));
        sb.append(",sensitiveTypeId=").append(String.valueOf(this.sensitiveTypeId));
        sb.append(",parentColumnKey=").append(String.valueOf(this.parentColumnKey));
        sb.append(",relationType=").append(String.valueOf(this.relationType));
        sb.append(",columnGroup=").append(String.valueOf(this.columnGroup));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSensitiveColumnsRequest)) {
            return false;
        }
        ListSensitiveColumnsRequest other = (ListSensitiveColumnsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.sensitiveDataModelId, other.sensitiveDataModelId) && Objects.equals(this.timeCreatedGreaterThanOrEqualTo, other.timeCreatedGreaterThanOrEqualTo) && Objects.equals(this.timeCreatedLessThan, other.timeCreatedLessThan) && Objects.equals(this.timeUpdatedGreaterThanOrEqualTo, other.timeUpdatedGreaterThanOrEqualTo) && Objects.equals(this.timeUpdatedLessThan, other.timeUpdatedLessThan) && Objects.equals((Object)this.sensitiveColumnLifecycleState, (Object)other.sensitiveColumnLifecycleState) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.columnName, other.columnName) && Objects.equals(this.objectType, other.objectType) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.status, other.status) && Objects.equals(this.sensitiveTypeId, other.sensitiveTypeId) && Objects.equals(this.parentColumnKey, other.parentColumnKey) && Objects.equals(this.relationType, other.relationType) && Objects.equals(this.columnGroup, other.columnGroup) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sensitiveDataModelId == null ? 43 : this.sensitiveDataModelId.hashCode());
        result = result * 59 + (this.timeCreatedGreaterThanOrEqualTo == null ? 43 : this.timeCreatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeCreatedLessThan == null ? 43 : this.timeCreatedLessThan.hashCode());
        result = result * 59 + (this.timeUpdatedGreaterThanOrEqualTo == null ? 43 : this.timeUpdatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUpdatedLessThan == null ? 43 : this.timeUpdatedLessThan.hashCode());
        result = result * 59 + (this.sensitiveColumnLifecycleState == null ? 43 : this.sensitiveColumnLifecycleState.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.sensitiveTypeId == null ? 43 : this.sensitiveTypeId.hashCode());
        result = result * 59 + (this.parentColumnKey == null ? 43 : this.parentColumnKey.hashCode());
        result = result * 59 + (this.relationType == null ? 43 : this.relationType.hashCode());
        result = result * 59 + (this.columnGroup == null ? 43 : this.columnGroup.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSensitiveColumnsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String sensitiveDataModelId = null;
        private Date timeCreatedGreaterThanOrEqualTo = null;
        private Date timeCreatedLessThan = null;
        private Date timeUpdatedGreaterThanOrEqualTo = null;
        private Date timeUpdatedLessThan = null;
        private SensitiveColumnLifecycleState sensitiveColumnLifecycleState = null;
        private List<String> schemaName = null;
        private List<String> objectName = null;
        private List<String> columnName = null;
        private List<ObjectType> objectType = null;
        private List<String> dataType = null;
        private List<Status> status = null;
        private List<String> sensitiveTypeId = null;
        private List<String> parentColumnKey = null;
        private List<RelationType> relationType = null;
        private String columnGroup = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder sensitiveDataModelId(String sensitiveDataModelId) {
            this.sensitiveDataModelId = sensitiveDataModelId;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            return this;
        }

        public Builder timeUpdatedGreaterThanOrEqualTo(Date timeUpdatedGreaterThanOrEqualTo) {
            this.timeUpdatedGreaterThanOrEqualTo = timeUpdatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeUpdatedLessThan(Date timeUpdatedLessThan) {
            this.timeUpdatedLessThan = timeUpdatedLessThan;
            return this;
        }

        public Builder sensitiveColumnLifecycleState(SensitiveColumnLifecycleState sensitiveColumnLifecycleState) {
            this.sensitiveColumnLifecycleState = sensitiveColumnLifecycleState;
            return this;
        }

        public Builder schemaName(List<String> schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder schemaName(String singularValue) {
            return this.schemaName(Arrays.asList(singularValue));
        }

        public Builder objectName(List<String> objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder objectName(String singularValue) {
            return this.objectName(Arrays.asList(singularValue));
        }

        public Builder columnName(List<String> columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder columnName(String singularValue) {
            return this.columnName(Arrays.asList(singularValue));
        }

        public Builder objectType(List<ObjectType> objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder objectType(ObjectType singularValue) {
            return this.objectType(Arrays.asList(singularValue));
        }

        public Builder dataType(List<String> dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder dataType(String singularValue) {
            return this.dataType(Arrays.asList(singularValue));
        }

        public Builder status(List<Status> status) {
            this.status = status;
            return this;
        }

        public Builder status(Status singularValue) {
            return this.status(Arrays.asList(singularValue));
        }

        public Builder sensitiveTypeId(List<String> sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            return this;
        }

        public Builder sensitiveTypeId(String singularValue) {
            return this.sensitiveTypeId(Arrays.asList(singularValue));
        }

        public Builder parentColumnKey(List<String> parentColumnKey) {
            this.parentColumnKey = parentColumnKey;
            return this;
        }

        public Builder parentColumnKey(String singularValue) {
            return this.parentColumnKey(Arrays.asList(singularValue));
        }

        public Builder relationType(List<RelationType> relationType) {
            this.relationType = relationType;
            return this;
        }

        public Builder relationType(RelationType singularValue) {
            return this.relationType(Arrays.asList(singularValue));
        }

        public Builder columnGroup(String columnGroup) {
            this.columnGroup = columnGroup;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSensitiveColumnsRequest o) {
            this.sensitiveDataModelId(o.getSensitiveDataModelId());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.timeCreatedLessThan(o.getTimeCreatedLessThan());
            this.timeUpdatedGreaterThanOrEqualTo(o.getTimeUpdatedGreaterThanOrEqualTo());
            this.timeUpdatedLessThan(o.getTimeUpdatedLessThan());
            this.sensitiveColumnLifecycleState(o.getSensitiveColumnLifecycleState());
            this.schemaName(o.getSchemaName());
            this.objectName(o.getObjectName());
            this.columnName(o.getColumnName());
            this.objectType(o.getObjectType());
            this.dataType(o.getDataType());
            this.status(o.getStatus());
            this.sensitiveTypeId(o.getSensitiveTypeId());
            this.parentColumnKey(o.getParentColumnKey());
            this.relationType(o.getRelationType());
            this.columnGroup(o.getColumnGroup());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSensitiveColumnsRequest build() {
            ListSensitiveColumnsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSensitiveColumnsRequest buildWithoutInvocationCallback() {
            ListSensitiveColumnsRequest request = new ListSensitiveColumnsRequest();
            request.sensitiveDataModelId = this.sensitiveDataModelId;
            request.timeCreatedGreaterThanOrEqualTo = this.timeCreatedGreaterThanOrEqualTo;
            request.timeCreatedLessThan = this.timeCreatedLessThan;
            request.timeUpdatedGreaterThanOrEqualTo = this.timeUpdatedGreaterThanOrEqualTo;
            request.timeUpdatedLessThan = this.timeUpdatedLessThan;
            request.sensitiveColumnLifecycleState = this.sensitiveColumnLifecycleState;
            request.schemaName = this.schemaName;
            request.objectName = this.objectName;
            request.columnName = this.columnName;
            request.objectType = this.objectType;
            request.dataType = this.dataType;
            request.status = this.status;
            request.sensitiveTypeId = this.sensitiveTypeId;
            request.parentColumnKey = this.parentColumnKey;
            request.relationType = this.relationType;
            request.columnGroup = this.columnGroup;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        SchemaName("schemaName"),
        ObjectName("objectName"),
        ColumnName("columnName"),
        DataType("dataType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RelationType implements BmcEnum
    {
        None("NONE"),
        AppDefined("APP_DEFINED"),
        DbDefined("DB_DEFINED");

        private final String value;
        private static Map<String, RelationType> map;

        private RelationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RelationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RelationType: " + key);
        }

        static {
            map = new HashMap<String, RelationType>();
            for (RelationType v : RelationType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Valid("VALID"),
        Invalid("INVALID");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ObjectType implements BmcEnum
    {
        All("ALL"),
        Table("TABLE"),
        EditioningView("EDITIONING_VIEW");

        private final String value;
        private static Map<String, ObjectType> map;

        private ObjectType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ObjectType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ObjectType: " + key);
        }

        static {
            map = new HashMap<String, ObjectType>();
            for (ObjectType v : ObjectType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

