/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListAlertAnalyticsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private String ifMatch;
    private Date timeStarted;
    private Date timeEnded;
    private String queryTimeZone;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private AccessLevel accessLevel;
    private String scimQuery;
    private List<SummaryField> summaryField;
    private List<GroupBy> groupBy;
    private String opcRetryToken;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String getQueryTimeZone() {
        return this.queryTimeZone;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getScimQuery() {
        return this.scimQuery;
    }

    public List<SummaryField> getSummaryField() {
        return this.summaryField;
    }

    public List<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).compartmentIdInSubtree(this.compartmentIdInSubtree).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).timeStarted(this.timeStarted).timeEnded(this.timeEnded).queryTimeZone(this.queryTimeZone).sortOrder(this.sortOrder).sortBy(this.sortBy).accessLevel(this.accessLevel).scimQuery(this.scimQuery).summaryField(this.summaryField).groupBy(this.groupBy).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(",timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(",queryTimeZone=").append(String.valueOf(this.queryTimeZone));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",scimQuery=").append(String.valueOf(this.scimQuery));
        sb.append(",summaryField=").append(String.valueOf(this.summaryField));
        sb.append(",groupBy=").append(String.valueOf(this.groupBy));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAlertAnalyticsRequest)) {
            return false;
        }
        ListAlertAnalyticsRequest other = (ListAlertAnalyticsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && Objects.equals(this.queryTimeZone, other.queryTimeZone) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.scimQuery, other.scimQuery) && Objects.equals(this.summaryField, other.summaryField) && Objects.equals(this.groupBy, other.groupBy) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + (this.queryTimeZone == null ? 43 : this.queryTimeZone.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.scimQuery == null ? 43 : this.scimQuery.hashCode());
        result = result * 59 + (this.summaryField == null ? 43 : this.summaryField.hashCode());
        result = result * 59 + (this.groupBy == null ? 43 : this.groupBy.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAlertAnalyticsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Boolean compartmentIdInSubtree = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private Date timeStarted = null;
        private Date timeEnded = null;
        private String queryTimeZone = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private AccessLevel accessLevel = null;
        private String scimQuery = null;
        private List<SummaryField> summaryField = null;
        private List<GroupBy> groupBy = null;
        private String opcRetryToken = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            return this;
        }

        public Builder queryTimeZone(String queryTimeZone) {
            this.queryTimeZone = queryTimeZone;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder scimQuery(String scimQuery) {
            this.scimQuery = scimQuery;
            return this;
        }

        public Builder summaryField(List<SummaryField> summaryField) {
            this.summaryField = summaryField;
            return this;
        }

        public Builder summaryField(SummaryField singularValue) {
            return this.summaryField(Arrays.asList(singularValue));
        }

        public Builder groupBy(List<GroupBy> groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public Builder groupBy(GroupBy singularValue) {
            return this.groupBy(Arrays.asList(singularValue));
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAlertAnalyticsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.timeStarted(o.getTimeStarted());
            this.timeEnded(o.getTimeEnded());
            this.queryTimeZone(o.getQueryTimeZone());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.accessLevel(o.getAccessLevel());
            this.scimQuery(o.getScimQuery());
            this.summaryField(o.getSummaryField());
            this.groupBy(o.getGroupBy());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAlertAnalyticsRequest build() {
            ListAlertAnalyticsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAlertAnalyticsRequest buildWithoutInvocationCallback() {
            ListAlertAnalyticsRequest request = new ListAlertAnalyticsRequest();
            request.compartmentId = this.compartmentId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.timeStarted = this.timeStarted;
            request.timeEnded = this.timeEnded;
            request.queryTimeZone = this.queryTimeZone;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.accessLevel = this.accessLevel;
            request.scimQuery = this.scimQuery;
            request.summaryField = this.summaryField;
            request.groupBy = this.groupBy;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }

    public static enum GroupBy implements BmcEnum
    {
        AlertType("alertType"),
        TargetIds("targetIds"),
        TargetNames("targetNames"),
        AlertSeverity("alertSeverity"),
        AlertStatus("alertStatus"),
        TimeCreated("timeCreated"),
        PolicyId("policyId");

        private final String value;
        private static Map<String, GroupBy> map;

        private GroupBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GroupBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid GroupBy: " + key);
        }

        static {
            map = new HashMap<String, GroupBy>();
            for (GroupBy v : GroupBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SummaryField implements BmcEnum
    {
        AlertType("alertType"),
        TargetIds("targetIds"),
        TargetNames("targetNames"),
        AlertSeverity("alertSeverity"),
        AlertStatus("alertStatus"),
        TimeCreated("timeCreated"),
        PolicyId("policyId"),
        Open("open"),
        Closed("closed"),
        Critical("critical"),
        High("high"),
        Medium("medium"),
        Low("low"),
        Alertcount("alertcount");

        private final String value;
        private static Map<String, SummaryField> map;

        private SummaryField(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SummaryField create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SummaryField: " + key);
        }

        static {
            map = new HashMap<String, SummaryField>();
            for (SummaryField v : SummaryField.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DisplayName("displayName"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

