/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetLibraryMaskingFormatRequest
extends BmcRequest<Void> {
    private String libraryMaskingFormatId;
    private String opcRequestId;

    public String getLibraryMaskingFormatId() {
        return this.libraryMaskingFormatId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().libraryMaskingFormatId(this.libraryMaskingFormatId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",libraryMaskingFormatId=").append(String.valueOf(this.libraryMaskingFormatId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetLibraryMaskingFormatRequest)) {
            return false;
        }
        GetLibraryMaskingFormatRequest other = (GetLibraryMaskingFormatRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.libraryMaskingFormatId, other.libraryMaskingFormatId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.libraryMaskingFormatId == null ? 43 : this.libraryMaskingFormatId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetLibraryMaskingFormatRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String libraryMaskingFormatId = null;
        private String opcRequestId = null;

        public Builder libraryMaskingFormatId(String libraryMaskingFormatId) {
            this.libraryMaskingFormatId = libraryMaskingFormatId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetLibraryMaskingFormatRequest o) {
            this.libraryMaskingFormatId(o.getLibraryMaskingFormatId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetLibraryMaskingFormatRequest build() {
            GetLibraryMaskingFormatRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetLibraryMaskingFormatRequest buildWithoutInvocationCallback() {
            GetLibraryMaskingFormatRequest request = new GetLibraryMaskingFormatRequest();
            request.libraryMaskingFormatId = this.libraryMaskingFormatId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

