/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.DownloadDiscoveryReportDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DownloadDiscoveryReportRequest
extends BmcRequest<DownloadDiscoveryReportDetails> {
    private String sensitiveDataModelId;
    private DownloadDiscoveryReportDetails downloadDiscoveryReportDetails;
    private String opcRequestId;

    public String getSensitiveDataModelId() {
        return this.sensitiveDataModelId;
    }

    public DownloadDiscoveryReportDetails getDownloadDiscoveryReportDetails() {
        return this.downloadDiscoveryReportDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public DownloadDiscoveryReportDetails getBody$() {
        return this.downloadDiscoveryReportDetails;
    }

    public Builder toBuilder() {
        return new Builder().sensitiveDataModelId(this.sensitiveDataModelId).downloadDiscoveryReportDetails(this.downloadDiscoveryReportDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",sensitiveDataModelId=").append(String.valueOf(this.sensitiveDataModelId));
        sb.append(",downloadDiscoveryReportDetails=").append(String.valueOf((Object)this.downloadDiscoveryReportDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadDiscoveryReportRequest)) {
            return false;
        }
        DownloadDiscoveryReportRequest other = (DownloadDiscoveryReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.sensitiveDataModelId, other.sensitiveDataModelId) && Objects.equals((Object)this.downloadDiscoveryReportDetails, (Object)other.downloadDiscoveryReportDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sensitiveDataModelId == null ? 43 : this.sensitiveDataModelId.hashCode());
        result = result * 59 + (this.downloadDiscoveryReportDetails == null ? 43 : this.downloadDiscoveryReportDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DownloadDiscoveryReportRequest, DownloadDiscoveryReportDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String sensitiveDataModelId = null;
        private DownloadDiscoveryReportDetails downloadDiscoveryReportDetails = null;
        private String opcRequestId = null;

        public Builder sensitiveDataModelId(String sensitiveDataModelId) {
            this.sensitiveDataModelId = sensitiveDataModelId;
            return this;
        }

        public Builder downloadDiscoveryReportDetails(DownloadDiscoveryReportDetails downloadDiscoveryReportDetails) {
            this.downloadDiscoveryReportDetails = downloadDiscoveryReportDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DownloadDiscoveryReportRequest o) {
            this.sensitiveDataModelId(o.getSensitiveDataModelId());
            this.downloadDiscoveryReportDetails(o.getDownloadDiscoveryReportDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DownloadDiscoveryReportRequest build() {
            DownloadDiscoveryReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DownloadDiscoveryReportDetails body) {
            this.downloadDiscoveryReportDetails(body);
            return this;
        }

        public DownloadDiscoveryReportRequest buildWithoutInvocationCallback() {
            DownloadDiscoveryReportRequest request = new DownloadDiscoveryReportRequest();
            request.sensitiveDataModelId = this.sensitiveDataModelId;
            request.downloadDiscoveryReportDetails = this.downloadDiscoveryReportDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

