/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.CompareSecurityAssessmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CompareSecurityAssessmentRequest
extends BmcRequest<CompareSecurityAssessmentDetails> {
    private String securityAssessmentId;
    private CompareSecurityAssessmentDetails compareSecurityAssessmentDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    public String getSecurityAssessmentId() {
        return this.securityAssessmentId;
    }

    public CompareSecurityAssessmentDetails getCompareSecurityAssessmentDetails() {
        return this.compareSecurityAssessmentDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public CompareSecurityAssessmentDetails getBody$() {
        return this.compareSecurityAssessmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().securityAssessmentId(this.securityAssessmentId).compareSecurityAssessmentDetails(this.compareSecurityAssessmentDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAssessmentId=").append(String.valueOf(this.securityAssessmentId));
        sb.append(",compareSecurityAssessmentDetails=").append(String.valueOf((Object)this.compareSecurityAssessmentDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompareSecurityAssessmentRequest)) {
            return false;
        }
        CompareSecurityAssessmentRequest other = (CompareSecurityAssessmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAssessmentId, other.securityAssessmentId) && Objects.equals((Object)this.compareSecurityAssessmentDetails, (Object)other.compareSecurityAssessmentDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAssessmentId == null ? 43 : this.securityAssessmentId.hashCode());
        result = result * 59 + (this.compareSecurityAssessmentDetails == null ? 43 : this.compareSecurityAssessmentDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CompareSecurityAssessmentRequest, CompareSecurityAssessmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAssessmentId = null;
        private CompareSecurityAssessmentDetails compareSecurityAssessmentDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder securityAssessmentId(String securityAssessmentId) {
            this.securityAssessmentId = securityAssessmentId;
            return this;
        }

        public Builder compareSecurityAssessmentDetails(CompareSecurityAssessmentDetails compareSecurityAssessmentDetails) {
            this.compareSecurityAssessmentDetails = compareSecurityAssessmentDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CompareSecurityAssessmentRequest o) {
            this.securityAssessmentId(o.getSecurityAssessmentId());
            this.compareSecurityAssessmentDetails(o.getCompareSecurityAssessmentDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CompareSecurityAssessmentRequest build() {
            CompareSecurityAssessmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CompareSecurityAssessmentDetails body) {
            this.compareSecurityAssessmentDetails(body);
            return this;
        }

        public CompareSecurityAssessmentRequest buildWithoutInvocationCallback() {
            CompareSecurityAssessmentRequest request = new CompareSecurityAssessmentRequest();
            request.securityAssessmentId = this.securityAssessmentId;
            request.compareSecurityAssessmentDetails = this.compareSecurityAssessmentDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

