/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class UDFFormatEntry
extends FormatEntry {
    @JsonProperty(value="userDefinedFunction")
    private final String userDefinedFunction;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public UDFFormatEntry(String description, String userDefinedFunction) {
        super(description);
        this.userDefinedFunction = userDefinedFunction;
    }

    public String getUserDefinedFunction() {
        return this.userDefinedFunction;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UDFFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", userDefinedFunction=").append(String.valueOf(this.userDefinedFunction));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UDFFormatEntry)) {
            return false;
        }
        UDFFormatEntry other = (UDFFormatEntry)((Object)o);
        return Objects.equals(this.userDefinedFunction, other.userDefinedFunction) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userDefinedFunction == null ? 43 : this.userDefinedFunction.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="userDefinedFunction")
        private String userDefinedFunction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder userDefinedFunction(String userDefinedFunction) {
            this.userDefinedFunction = userDefinedFunction;
            this.__explicitlySet__.add("userDefinedFunction");
            return this;
        }

        public UDFFormatEntry build() {
            UDFFormatEntry model = new UDFFormatEntry(this.description, this.userDefinedFunction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UDFFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("userDefinedFunction")) {
                this.userDefinedFunction(model.getUserDefinedFunction());
            }
            return this;
        }
    }
}

