/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class SubstringFormatEntry
extends FormatEntry {
    @JsonProperty(value="startPosition")
    private final Integer startPosition;
    @JsonProperty(value="length")
    private final Integer length;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SubstringFormatEntry(String description, Integer startPosition, Integer length) {
        super(description);
        this.startPosition = startPosition;
        this.length = length;
    }

    public Integer getStartPosition() {
        return this.startPosition;
    }

    public Integer getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubstringFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", startPosition=").append(String.valueOf(this.startPosition));
        sb.append(", length=").append(String.valueOf(this.length));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubstringFormatEntry)) {
            return false;
        }
        SubstringFormatEntry other = (SubstringFormatEntry)((Object)o);
        return Objects.equals(this.startPosition, other.startPosition) && Objects.equals(this.length, other.length) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.startPosition == null ? 43 : this.startPosition.hashCode());
        result = result * 59 + (this.length == null ? 43 : this.length.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="startPosition")
        private Integer startPosition;
        @JsonProperty(value="length")
        private Integer length;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder startPosition(Integer startPosition) {
            this.startPosition = startPosition;
            this.__explicitlySet__.add("startPosition");
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            this.__explicitlySet__.add("length");
            return this;
        }

        public SubstringFormatEntry build() {
            SubstringFormatEntry model = new SubstringFormatEntry(this.description, this.startPosition, this.length);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubstringFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("startPosition")) {
                this.startPosition(model.getStartPosition());
            }
            if (model.wasPropertyExplicitlySet("length")) {
                this.length(model.getLength());
            }
            return this;
        }
    }
}

