/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.DiscoveryLifecycleState;
import com.oracle.bmc.datasafe.model.SensitiveType;
import com.oracle.bmc.datasafe.model.SensitiveTypeSource;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityType")
@JsonFilter(value="explicitlySetFilter")
public final class SensitiveTypePattern
extends SensitiveType {
    @JsonProperty(value="namePattern")
    private final String namePattern;
    @JsonProperty(value="commentPattern")
    private final String commentPattern;
    @JsonProperty(value="dataPattern")
    private final String dataPattern;
    @JsonProperty(value="searchType")
    private final SearchType searchType;
    @JsonProperty(value="defaultMaskingFormatId")
    private final String defaultMaskingFormatId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SensitiveTypePattern(String id, String displayName, String compartmentId, DiscoveryLifecycleState lifecycleState, String shortName, SensitiveTypeSource source, Date timeCreated, Date timeUpdated, String description, String parentCategoryId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String namePattern, String commentPattern, String dataPattern, SearchType searchType, String defaultMaskingFormatId) {
        super(id, displayName, compartmentId, lifecycleState, shortName, source, timeCreated, timeUpdated, description, parentCategoryId, freeformTags, definedTags, systemTags);
        this.namePattern = namePattern;
        this.commentPattern = commentPattern;
        this.dataPattern = dataPattern;
        this.searchType = searchType;
        this.defaultMaskingFormatId = defaultMaskingFormatId;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public String getCommentPattern() {
        return this.commentPattern;
    }

    public String getDataPattern() {
        return this.dataPattern;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public String getDefaultMaskingFormatId() {
        return this.defaultMaskingFormatId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SensitiveTypePattern(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", namePattern=").append(String.valueOf(this.namePattern));
        sb.append(", commentPattern=").append(String.valueOf(this.commentPattern));
        sb.append(", dataPattern=").append(String.valueOf(this.dataPattern));
        sb.append(", searchType=").append(String.valueOf((Object)this.searchType));
        sb.append(", defaultMaskingFormatId=").append(String.valueOf(this.defaultMaskingFormatId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SensitiveTypePattern)) {
            return false;
        }
        SensitiveTypePattern other = (SensitiveTypePattern)((Object)o);
        return Objects.equals(this.namePattern, other.namePattern) && Objects.equals(this.commentPattern, other.commentPattern) && Objects.equals(this.dataPattern, other.dataPattern) && Objects.equals((Object)this.searchType, (Object)other.searchType) && Objects.equals(this.defaultMaskingFormatId, other.defaultMaskingFormatId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namePattern == null ? 43 : this.namePattern.hashCode());
        result = result * 59 + (this.commentPattern == null ? 43 : this.commentPattern.hashCode());
        result = result * 59 + (this.dataPattern == null ? 43 : this.dataPattern.hashCode());
        result = result * 59 + (this.searchType == null ? 43 : this.searchType.hashCode());
        result = result * 59 + (this.defaultMaskingFormatId == null ? 43 : this.defaultMaskingFormatId.hashCode());
        return result;
    }

    public static enum SearchType implements BmcEnum
    {
        Or("OR"),
        And("AND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SearchType> map;

        private SearchType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SearchType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SearchType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SearchType.class);
            map = new HashMap<String, SearchType>();
            for (SearchType v : SearchType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private DiscoveryLifecycleState lifecycleState;
        @JsonProperty(value="shortName")
        private String shortName;
        @JsonProperty(value="source")
        private SensitiveTypeSource source;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="parentCategoryId")
        private String parentCategoryId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="namePattern")
        private String namePattern;
        @JsonProperty(value="commentPattern")
        private String commentPattern;
        @JsonProperty(value="dataPattern")
        private String dataPattern;
        @JsonProperty(value="searchType")
        private SearchType searchType;
        @JsonProperty(value="defaultMaskingFormatId")
        private String defaultMaskingFormatId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(DiscoveryLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder shortName(String shortName) {
            this.shortName = shortName;
            this.__explicitlySet__.add("shortName");
            return this;
        }

        public Builder source(SensitiveTypeSource source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder parentCategoryId(String parentCategoryId) {
            this.parentCategoryId = parentCategoryId;
            this.__explicitlySet__.add("parentCategoryId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder namePattern(String namePattern) {
            this.namePattern = namePattern;
            this.__explicitlySet__.add("namePattern");
            return this;
        }

        public Builder commentPattern(String commentPattern) {
            this.commentPattern = commentPattern;
            this.__explicitlySet__.add("commentPattern");
            return this;
        }

        public Builder dataPattern(String dataPattern) {
            this.dataPattern = dataPattern;
            this.__explicitlySet__.add("dataPattern");
            return this;
        }

        public Builder searchType(SearchType searchType) {
            this.searchType = searchType;
            this.__explicitlySet__.add("searchType");
            return this;
        }

        public Builder defaultMaskingFormatId(String defaultMaskingFormatId) {
            this.defaultMaskingFormatId = defaultMaskingFormatId;
            this.__explicitlySet__.add("defaultMaskingFormatId");
            return this;
        }

        public SensitiveTypePattern build() {
            SensitiveTypePattern model = new SensitiveTypePattern(this.id, this.displayName, this.compartmentId, this.lifecycleState, this.shortName, this.source, this.timeCreated, this.timeUpdated, this.description, this.parentCategoryId, this.freeformTags, this.definedTags, this.systemTags, this.namePattern, this.commentPattern, this.dataPattern, this.searchType, this.defaultMaskingFormatId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SensitiveTypePattern model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("shortName")) {
                this.shortName(model.getShortName());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("parentCategoryId")) {
                this.parentCategoryId(model.getParentCategoryId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("namePattern")) {
                this.namePattern(model.getNamePattern());
            }
            if (model.wasPropertyExplicitlySet("commentPattern")) {
                this.commentPattern(model.getCommentPattern());
            }
            if (model.wasPropertyExplicitlySet("dataPattern")) {
                this.dataPattern(model.getDataPattern());
            }
            if (model.wasPropertyExplicitlySet("searchType")) {
                this.searchType(model.getSearchType());
            }
            if (model.wasPropertyExplicitlySet("defaultMaskingFormatId")) {
                this.defaultMaskingFormatId(model.getDefaultMaskingFormatId());
            }
            return this;
        }
    }
}

