/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.Diffs;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SecurityAssessmentComparisonPerTarget
extends ExplicitlySetBmcModel {
    @JsonProperty(value="baselineTargetId")
    private final String baselineTargetId;
    @JsonProperty(value="currentTargetId")
    private final String currentTargetId;
    @JsonProperty(value="auditing")
    private final List<Diffs> auditing;
    @JsonProperty(value="authorizationControl")
    private final List<Diffs> authorizationControl;
    @JsonProperty(value="dataEncryption")
    private final List<Diffs> dataEncryption;
    @JsonProperty(value="dbConfiguration")
    private final List<Diffs> dbConfiguration;
    @JsonProperty(value="fineGrainedAccessControl")
    private final List<Diffs> fineGrainedAccessControl;
    @JsonProperty(value="privilegesAndRoles")
    private final List<Diffs> privilegesAndRoles;
    @JsonProperty(value="userAccounts")
    private final List<Diffs> userAccounts;

    @Deprecated
    @ConstructorProperties(value={"baselineTargetId", "currentTargetId", "auditing", "authorizationControl", "dataEncryption", "dbConfiguration", "fineGrainedAccessControl", "privilegesAndRoles", "userAccounts"})
    public SecurityAssessmentComparisonPerTarget(String baselineTargetId, String currentTargetId, List<Diffs> auditing, List<Diffs> authorizationControl, List<Diffs> dataEncryption, List<Diffs> dbConfiguration, List<Diffs> fineGrainedAccessControl, List<Diffs> privilegesAndRoles, List<Diffs> userAccounts) {
        this.baselineTargetId = baselineTargetId;
        this.currentTargetId = currentTargetId;
        this.auditing = auditing;
        this.authorizationControl = authorizationControl;
        this.dataEncryption = dataEncryption;
        this.dbConfiguration = dbConfiguration;
        this.fineGrainedAccessControl = fineGrainedAccessControl;
        this.privilegesAndRoles = privilegesAndRoles;
        this.userAccounts = userAccounts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBaselineTargetId() {
        return this.baselineTargetId;
    }

    public String getCurrentTargetId() {
        return this.currentTargetId;
    }

    public List<Diffs> getAuditing() {
        return this.auditing;
    }

    public List<Diffs> getAuthorizationControl() {
        return this.authorizationControl;
    }

    public List<Diffs> getDataEncryption() {
        return this.dataEncryption;
    }

    public List<Diffs> getDbConfiguration() {
        return this.dbConfiguration;
    }

    public List<Diffs> getFineGrainedAccessControl() {
        return this.fineGrainedAccessControl;
    }

    public List<Diffs> getPrivilegesAndRoles() {
        return this.privilegesAndRoles;
    }

    public List<Diffs> getUserAccounts() {
        return this.userAccounts;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityAssessmentComparisonPerTarget(");
        sb.append("super=").append(super.toString());
        sb.append("baselineTargetId=").append(String.valueOf(this.baselineTargetId));
        sb.append(", currentTargetId=").append(String.valueOf(this.currentTargetId));
        sb.append(", auditing=").append(String.valueOf(this.auditing));
        sb.append(", authorizationControl=").append(String.valueOf(this.authorizationControl));
        sb.append(", dataEncryption=").append(String.valueOf(this.dataEncryption));
        sb.append(", dbConfiguration=").append(String.valueOf(this.dbConfiguration));
        sb.append(", fineGrainedAccessControl=").append(String.valueOf(this.fineGrainedAccessControl));
        sb.append(", privilegesAndRoles=").append(String.valueOf(this.privilegesAndRoles));
        sb.append(", userAccounts=").append(String.valueOf(this.userAccounts));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityAssessmentComparisonPerTarget)) {
            return false;
        }
        SecurityAssessmentComparisonPerTarget other = (SecurityAssessmentComparisonPerTarget)((Object)o);
        return Objects.equals(this.baselineTargetId, other.baselineTargetId) && Objects.equals(this.currentTargetId, other.currentTargetId) && Objects.equals(this.auditing, other.auditing) && Objects.equals(this.authorizationControl, other.authorizationControl) && Objects.equals(this.dataEncryption, other.dataEncryption) && Objects.equals(this.dbConfiguration, other.dbConfiguration) && Objects.equals(this.fineGrainedAccessControl, other.fineGrainedAccessControl) && Objects.equals(this.privilegesAndRoles, other.privilegesAndRoles) && Objects.equals(this.userAccounts, other.userAccounts) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.baselineTargetId == null ? 43 : this.baselineTargetId.hashCode());
        result = result * 59 + (this.currentTargetId == null ? 43 : this.currentTargetId.hashCode());
        result = result * 59 + (this.auditing == null ? 43 : this.auditing.hashCode());
        result = result * 59 + (this.authorizationControl == null ? 43 : this.authorizationControl.hashCode());
        result = result * 59 + (this.dataEncryption == null ? 43 : this.dataEncryption.hashCode());
        result = result * 59 + (this.dbConfiguration == null ? 43 : this.dbConfiguration.hashCode());
        result = result * 59 + (this.fineGrainedAccessControl == null ? 43 : this.fineGrainedAccessControl.hashCode());
        result = result * 59 + (this.privilegesAndRoles == null ? 43 : this.privilegesAndRoles.hashCode());
        result = result * 59 + (this.userAccounts == null ? 43 : this.userAccounts.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="baselineTargetId")
        private String baselineTargetId;
        @JsonProperty(value="currentTargetId")
        private String currentTargetId;
        @JsonProperty(value="auditing")
        private List<Diffs> auditing;
        @JsonProperty(value="authorizationControl")
        private List<Diffs> authorizationControl;
        @JsonProperty(value="dataEncryption")
        private List<Diffs> dataEncryption;
        @JsonProperty(value="dbConfiguration")
        private List<Diffs> dbConfiguration;
        @JsonProperty(value="fineGrainedAccessControl")
        private List<Diffs> fineGrainedAccessControl;
        @JsonProperty(value="privilegesAndRoles")
        private List<Diffs> privilegesAndRoles;
        @JsonProperty(value="userAccounts")
        private List<Diffs> userAccounts;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder baselineTargetId(String baselineTargetId) {
            this.baselineTargetId = baselineTargetId;
            this.__explicitlySet__.add("baselineTargetId");
            return this;
        }

        public Builder currentTargetId(String currentTargetId) {
            this.currentTargetId = currentTargetId;
            this.__explicitlySet__.add("currentTargetId");
            return this;
        }

        public Builder auditing(List<Diffs> auditing) {
            this.auditing = auditing;
            this.__explicitlySet__.add("auditing");
            return this;
        }

        public Builder authorizationControl(List<Diffs> authorizationControl) {
            this.authorizationControl = authorizationControl;
            this.__explicitlySet__.add("authorizationControl");
            return this;
        }

        public Builder dataEncryption(List<Diffs> dataEncryption) {
            this.dataEncryption = dataEncryption;
            this.__explicitlySet__.add("dataEncryption");
            return this;
        }

        public Builder dbConfiguration(List<Diffs> dbConfiguration) {
            this.dbConfiguration = dbConfiguration;
            this.__explicitlySet__.add("dbConfiguration");
            return this;
        }

        public Builder fineGrainedAccessControl(List<Diffs> fineGrainedAccessControl) {
            this.fineGrainedAccessControl = fineGrainedAccessControl;
            this.__explicitlySet__.add("fineGrainedAccessControl");
            return this;
        }

        public Builder privilegesAndRoles(List<Diffs> privilegesAndRoles) {
            this.privilegesAndRoles = privilegesAndRoles;
            this.__explicitlySet__.add("privilegesAndRoles");
            return this;
        }

        public Builder userAccounts(List<Diffs> userAccounts) {
            this.userAccounts = userAccounts;
            this.__explicitlySet__.add("userAccounts");
            return this;
        }

        public SecurityAssessmentComparisonPerTarget build() {
            SecurityAssessmentComparisonPerTarget model = new SecurityAssessmentComparisonPerTarget(this.baselineTargetId, this.currentTargetId, this.auditing, this.authorizationControl, this.dataEncryption, this.dbConfiguration, this.fineGrainedAccessControl, this.privilegesAndRoles, this.userAccounts);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SecurityAssessmentComparisonPerTarget model) {
            if (model.wasPropertyExplicitlySet("baselineTargetId")) {
                this.baselineTargetId(model.getBaselineTargetId());
            }
            if (model.wasPropertyExplicitlySet("currentTargetId")) {
                this.currentTargetId(model.getCurrentTargetId());
            }
            if (model.wasPropertyExplicitlySet("auditing")) {
                this.auditing(model.getAuditing());
            }
            if (model.wasPropertyExplicitlySet("authorizationControl")) {
                this.authorizationControl(model.getAuthorizationControl());
            }
            if (model.wasPropertyExplicitlySet("dataEncryption")) {
                this.dataEncryption(model.getDataEncryption());
            }
            if (model.wasPropertyExplicitlySet("dbConfiguration")) {
                this.dbConfiguration(model.getDbConfiguration());
            }
            if (model.wasPropertyExplicitlySet("fineGrainedAccessControl")) {
                this.fineGrainedAccessControl(model.getFineGrainedAccessControl());
            }
            if (model.wasPropertyExplicitlySet("privilegesAndRoles")) {
                this.privilegesAndRoles(model.getPrivilegesAndRoles());
            }
            if (model.wasPropertyExplicitlySet("userAccounts")) {
                this.userAccounts(model.getUserAccounts());
            }
            return this;
        }
    }
}

